<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->
<!-- $Revision:   1.4  $ -->

<xsl:stylesheet 
xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
xmlns:fo="http://www.w3.org/1999/XSL/Format" 
xmlns:NSF_ApplicationChecklist_1_3="http://apply.grants.gov/forms/NSF_ApplicationChecklist_1_3-V1.3" 
xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" 
xmlns:glob="http://apply.grants.gov/system/Global-V1.0" 
xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" 
xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" 
xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
   <xsl:output method="xml" indent="yes"/>
   <xsl:template match="NSF_ApplicationChecklist_1_3:NSF_ApplicationChecklist_1_3">
      <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
         <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.2in" margin-right="0.2in">
               <fo:region-body margin-top="0.2in" margin-bottom="0.4in"/>
               <fo:region-after extent="0.4in"/>
            </fo:simple-page-master>
         </fo:layout-master-set>
         <fo:page-sequence master-reference="default-page" format="1" initial-page-number="1">
            <fo:static-content flow-name="xsl-region-after">
               <fo:table width="100%" table-layout="fixed">
                  <fo:table-column width="100%"/>
                  <fo:table-body>
                     <fo:table-row>
                        <fo:table-cell line-height="11pt" display-align="after" text-align="right">
                           <fo:block>
                              <fo:inline text-align="right" font-size="6px">OMB Number 3145-0058</fo:inline>
                           </fo:block>
                        </fo:table-cell>
                     </fo:table-row>
                  </fo:table-body>
               </fo:table>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body">
<!-- DATA GOES HERE Page 1-->

               <!-- SF 424 (R R) Cover Sheet 20px, 234px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="236px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="234px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckCoverSheet"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Renewal Applications 264.57142857142856px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="264.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckRenewal"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="264.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckRenewal"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="264.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckRenewal"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Full Application Related to Submission of a Preliminary Application 288px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="288px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckFullApp"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="288px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckFullApp"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="288px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckFullApp"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Type of Application 320.57142857142856px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="320.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckTypeApp"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="320.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckTypeApp"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Application Certifications 337.14285714285717px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="337.14285714285717px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckAppCert"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="337.14285714285717px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CoverSheet/NSF_ApplicationChecklist_1_3:CheckAppCert"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Research & Related Project/Performance Site Location(s) 382.2857142857143px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="382.2857142857143px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="381px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckRRSite"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Research & Related Other Project Information 417.14285714285717px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="417.14285714285717px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="416px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckRROtherInfo"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Project Summary/Abstract 441.14285714285717px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="441.14285714285717px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="439.7px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckProjectSummary"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Project Narrative 485.14285714285717px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="485.14285714285717px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="483.7px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckProjectNarrative"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Merit Review Criteria 540.5714285714286px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMeritReview"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMeritReview"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMeritReview"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
<!--ele adding for 1.3 -->
            <!-- Check Mentoring -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMentoring"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMentoring"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckMentoring"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
<!-- end ele addition -->
               <!-- Inclusion of URLs (Universal Resource Locators) within the Project Narrative 573.1428571428571px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckURL"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckURL"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckURL"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Results from Prior NSF Support 618.8571428571429px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckPriorSupport"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckPriorSupport"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckPriorSupport"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Human-resource information 653.1428571428571px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckHRInfo"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckHRInfo"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:ProjectNarrative/NSF_ApplicationChecklist_1_3:CheckHRInfo"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>


               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="13.714285714285714px" height="14.857142857142858px" width="130.85714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="9pt" font-style="normal" font-family="Helvetica" font-weight="bold">APPLICATION CHECKLIST</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="28.571428571428573px" height="14.857142857142858px" width="140px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">National Science Foundation (NSF)</fo:block>
               </fo:block-container>
				<!--Line-->
				<fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="36px" height="2px" width="550px">
                  <fo:block><fo:leader leader-length="100%" leader-pattern="rule" rule-style="solid" rule-thickness="0.5px" /></fo:block>
               </fo:block-container>               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="50.285714285714285px" height="13.142857142857142px" width="502.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">It is imperative that all applications conform to the application preparation and submission instructions identified in the SF 424 (R&amp;R), the NSF</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="60px" height="13.142857142857142px" width="350.42857142857144px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Grants.gov Application Manual, and where specified, the NSF Grant Proposal Guide (GPG) </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="341px" hyphenate="true" language="en" top="60px" height="13.142857142857142px" width="190px">
                  <fo:block background-color="transparent" color="#0000ff" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">http://www.nsf.gov/pubsys/ods/getpub.cfm?gpg.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="126.28571428571429px" height="51.42857142857143px" width="505.14285714285717px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Prior to electronic submission via the Grants.gov portal, it is strongly recommended that an administrative review be conducted to ensure that an application complies with all application preparation instructions, in the format specified.  This checklist is not intended to be an all-inclusive repetition of the required application contents and associated application preparation guidelines.  It is, however, meant to highlight certain critical items so they will not be overlooked when the application is prepared.  Complete <fo:inline font-weight="bold" text-decoration="underline">all</fo:inline> of the below items in order to submit your application. Select the appropriate response for each item.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="192.57142857142858px" height="12.571428571428571px" width="96px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">SF 424 R&amp;R Forms</fo:block>
               </fo:block-container>
               
               <!--Line-->
				<fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="196px" height="2px" width="550px">
                  <fo:block><fo:leader leader-length="100%" leader-pattern="rule" rule-style="solid" rule-thickness="0.5px" /></fo:block>
               </fo:block-container>
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="264.57142857142856px" height="12.571428571428571px" width="95.42857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Renewal Applications:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="288px" height="12.571428571428571px" width="262.28571428571428px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Full Application Related to Submission of a Preliminary Application:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="320.57142857142856px" height="12.571428571428571px" width="78.28571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Type of Application:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="337.14285714285717px" height="12.571428571428571px" width="108.57142857142857px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Application Certifications:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="188px" hyphenate="true" language="en" top="264.57142857142856px" height="12.571428571428571px" width="350px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">For renewal applications, enter the previous award number in the Federal Identifier field. (Block 4)</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="360.2857142857143px" hyphenate="true" language="en" top="288px" height="12.571428571428571px" width="200.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If a new full application is being submitted that is related</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="297.7142857142857px" height="22.857142857142858px" width="440.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">to a previously submitted preliminary application, enter the assigned preliminary application number in the Federal Identifier field. (Block 4)</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="236px" height="12.571428571428571px" width="136px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">SF 424 (R&amp;R) Cover Sheet </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="2.2857142857142856px" hyphenate="true" language="en" top="214.85714285714286px" height="12.571428571428571px" width="137.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="7pt" font-style="normal" font-family="Helvetica" font-weight="bold">CHECK SECTION COMPLETED</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="250.28571428571428px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="57.142857142857146px" hyphenate="true" language="en" top="250.28571428571428px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="74.28571428571429px" hyphenate="true" language="en" top="250.28571428571428px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="202px" hyphenate="true" language="en" top="337.14285714285717px" height="12.571428571428571px" width="360px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">The requisite application certifications are submitted by the Authorized Organizational Representative </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="178.57142857142858px" hyphenate="true" language="en" top="320.57142857142856px" height="12.571428571428571px" width="380.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">For purposes of NSF, the box for "Continuation" will not be utilized and should not be checked. (Block 8)</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="346.2857142857143px" height="12.571428571428571px" width="444.57142857142856px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">upon checking the "I agree" box (Block 18) and submitting the application.  See GPG Chapter II.C.1.e, Proposal Certifications</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="357.14285714285717px" height="12.571428571428571px" width="266.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">for a complete listing of the requisite certifications.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="266px" hyphenate="true" language="en" top="382.2857142857143px" height="12.571428571428571px" width="325.7142857142857px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Indicate the primary site where the work will be performed. If a portion of the project </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.714285714285715px" hyphenate="true" language="en" top="394.2857142857143px" height="12.571428571428571px" width="184px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">will be performed at any other site(s), so identify.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.714285714285715px" hyphenate="true" language="en" top="382.2857142857143px" height="12.571428571428571px" width="242.28571428571428px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Research &amp; Related Project/Performance Site Location(s):</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="222px" hyphenate="true" language="en" top="417.14285714285717px" height="12.571428571428571px" width="313.14285714285717px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Complete questions 1 through 5 and attach files in Blocks 6 - 11 as specified.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42.285714285714285px" hyphenate="true" language="en" top="417.14285714285717px" height="12.571428571428571px" width="177.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Research &amp; Related Other Project Information:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="485.14285714285717px" height="12.571428571428571px" width="74.28571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Project Narrative:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="496px" height="12.571428571428571px" width="500.57142857142856px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Related Other Project Information Form. See GPG Chapter II.C.2.d, Project Description, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="109px" hyphenate="true" language="en" top="485.14285714285717px" height="12.571428571428571px" width="456px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(referred to in the GPG as Project Description) Note limitation of 15-pages. Attach Project Narrative in Block 7 of the Research &amp;</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.714285714285715px" hyphenate="true" language="en" top="441.14285714285717px" height="12.571428571428571px" width="108px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Project Summary/Abstract:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.714285714285715px" hyphenate="true" language="en" top="451.42857142857144px" height="12.571428571428571px" width="520px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">body of the Project Summary. Attach in Block 6 of the Research &amp; Related Other Project Information Form. See GPG Chapter II.C.2.b, Project</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="41.714285714285715px" hyphenate="true" language="en" top="462.85714285714283px" height="12.571428571428571px" width="118.28571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Summary, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="147px" hyphenate="true" language="en" top="441.14285714285717px" height="12.571428571428571px" width="410px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Note limitation of one page, and the requirement that both merit review criteria be separately addressed within the</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="522.8571428571429px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="57.142857142857146px" hyphenate="true" language="en" top="522.8571428571429px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="74.28571428571429px" hyphenate="true" language="en" top="522.8571428571429px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="82.28571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Merit Review Criteria:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="550.8571428571429px" height="12.571428571428571px" width="42.857142857142854px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">II.C.2.d.(i).</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="144px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Results from Prior NSF Support:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100.57142857142857px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="124px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Human-resource information:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100.57142857142857px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="300px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Inclusion of URLs (Universal Resource Locators) within the Project Narrative:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="185px" hyphenate="true" language="en" top="541.1428571428571px" height="12.571428571428571px" width="358.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Ensure both merit review criteria are described as an integral part of the narrative.  See GPG Chapter</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="226px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="322.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Required only for PIs and co-PIs that have received NSF support within last 5 years.  See</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="216px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="315px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Required information for renewal applications from academic institutions only.  See GPG</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100.57142857142857px" hyphenate="true" language="en" top="593.7142857142857px" height="12.571428571428571px" width="450px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">application should not be used because reviewers are under no obligation to view such sites.  See GPG Chapter II.C.2.d.(ii).</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="398px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="153.71428571428572px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">PIs are advised that the Project Narrative</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100.57142857142857px" hyphenate="true" language="en" top="583.4285714285714px" height="12.571428571428571px" width="460px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">must be self-contained and are cautioned that URLs (Internet addresses) that provide information necessary to the review of the </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.571428571428571px" hyphenate="true" language="en" top="709.7142857142857px" height="12px" width="528.5714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">submitted to NSF via Grants.gov.
  </fo:block>
               </fo:block-container>
               
				<!--Line-->
				<fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="680px" height="2px" width="550px">
                  <fo:block><fo:leader leader-length="100%" leader-pattern="rule" rule-style="solid" rule-thickness="0.5px" /></fo:block>
               </fo:block-container>
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.571428571428571px" hyphenate="true" language="en" top="697.7142857142857px" height="12px" width="528.5714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">For consistency with the SF 424 (R&amp;R) application and instructions, in lieu of the term "proposal", NSF is using the term application for all proposals </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="136px" hyphenate="true" language="en" top="49.714285714285715px" height="9.142857142857142px" width="7.428571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="5pt" font-style="normal" font-family="Helvetica" font-weight="normal">1</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.428571428571429px" hyphenate="true" language="en" top="718.8571428571429px" height="9.142857142857142px" width="7.428571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="5pt" font-style="normal" font-family="Helvetica" font-weight="normal">2</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="136px" hyphenate="true" language="en" top="549.1428571428571px" height="9.142857142857142px" width="7.428571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="5pt" font-style="normal" font-family="Helvetica" font-weight="normal">2</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="7.428571428571429px" hyphenate="true" language="en" top="693.7142857142857px" height="9.142857142857142px" width="7.428571428571429px">
                  <fo:block background-color="transparent" color="#000000" font-size="5pt" font-style="normal" font-family="Helvetica" font-weight="normal">1</fo:block>
               </fo:block-container>

               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.142857142857146px" hyphenate="true" language="en" top="266.85714285714283px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32.57142857142857px" hyphenate="true" language="en" top="289.7142857142857px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32px" hyphenate="true" language="en" top="540.5714285714286px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32px" hyphenate="true" language="en" top="618.8571428571429px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32px" hyphenate="true" language="en" top="653.1428571428571px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32px" hyphenate="true" language="en" top="573.1428571428571px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="69.71428571428571px" height="50.285714285714285px" width="502.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Applications also must comply with NSF font, spacing and margin requirements.  The guidelines established in the GPG Chapter II.B establish minimum requirements, however, readability is of utmost importance and should take precedence in selection of an appropriate font.  Conformance with all preparation and submission instructions is required and will be strictly enforced unless a deviation has been approved in advance of application submission.  NSF may return without review applications that are not consistent with these instructions. </fo:block>
               </fo:block-container>

               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="108.57142857142855px" height="13.142857142857142px" width="350.42857142857144px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">See GPG Chapter IV.B, Return Without Review </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="191.428571428571429px" hyphenate="true" language="en" top="108.57142857142855px" height="13.142857142857142px" width="190px">
                  <fo:block background-color="transparent" color="#0000ff" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">http://www.nsf.gov/pubs/2004/nsf042/4.htm#IVB</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="375.428571428571429px" hyphenate="true" language="en" top="108.57142857142855px" height="13.142857142857142px" width="350.42857142857144px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">, for additional information.</fo:block>
               </fo:block-container>


               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32.57142857142857px" hyphenate="true" language="en" top="322.85714285714283px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32.57142857142857px" hyphenate="true" language="en" top="338.85714285714283px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100px" hyphenate="true" language="en" top="629.1428571428571px" height="12.571428571428571px" width="94.85714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">GPG Chapter II.C.2.d(iii).</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="100.57142857142857px" hyphenate="true" language="en" top="664px" height="12.571428571428571px" width="75.42857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Chapter V.B.2.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.571428571428571px" hyphenate="true" language="en" top="723.4285714285714px" height="12.571428571428571px" width="430px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Examples illustrating activities likely to demonstrate broader impacts are available electronically on the NSF Website at: </fo:block>
               </fo:block-container>

               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8.571428571428571px" hyphenate="true" language="en" top="735px" height="12.571428571428571px" width="200px">
                  <fo:block background-color="transparent" color="#0000ff" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">http://www.nsf.gov/pubs/gpg/broaderimpacts.pdf</fo:block>
               </fo:block-container>

               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.857142857142857px" hyphenate="true" language="en" top="236.57142857142858px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.857142857142857px" hyphenate="true" language="en" top="382.2857142857143px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.857142857142857px" hyphenate="true" language="en" top="417.14285714285717px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.857142857142857px" hyphenate="true" language="en" top="441.14285714285717px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="6.857142857142857px" hyphenate="true" language="en" top="485.14285714285717px" height="12.571428571428571px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
              
            </fo:flow>
         </fo:page-sequence>
         <fo:page-sequence master-reference="default-page" format="1" initial-page-number="2">
            <fo:static-content flow-name="xsl-region-after">
               <fo:table width="100%" table-layout="fixed">
                  <fo:table-column width="100%"/>
                  <fo:table-body>
                     <fo:table-row>
                        <fo:table-cell line-height="11pt" display-align="after" text-align="right">
                           <fo:block>
                              <fo:inline text-align="right" font-size="6px">OMB Number 3145-0058</fo:inline>
                           </fo:block>
                        </fo:table-cell>
                     </fo:table-row>
                  </fo:table-body>
               </fo:table>
            </fo:static-content>
            <fo:flow flow-name="xsl-region-body">

<!-- DATA GOES HERE Page 2-->

               <!-- Bibliography and References Cited 21.714285714285715px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="21.714285714285715px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="21px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckBiblio"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Facilities and Other Resources 60.57142857142857px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="60.57142857142857px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="59.5px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckFacilities"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Equipment -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="88px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="87.5px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckEquipment"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Special Information and Supplementary Documentation 130.28571428571428px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="130.28571428571428px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckSuppDoc"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="130.28571428571428px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckSuppDoc"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="130.28571428571428px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckSuppDoc"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Any additional items specified in a relevant NSF Program Solicitation 169.71428571428572px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="169.71428571428572px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckAdditionalItems"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="169.71428571428572px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckAdditionalItems"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="169.71428571428572px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:Equipment/NSF_ApplicationChecklist_1_3:CheckAdditionalItems"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Research & Related Senior/Key Person Profile 196.57142857142858px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="196.57142857142858px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="195px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRSrProfile/NSF_ApplicationChecklist_1_3:CheckRRSrProfile"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Biographical Sketch(es) 249.71428571428572px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="249.71428571428572px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRSrProfile/NSF_ApplicationChecklist_1_3:CheckBioSketch"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="249.71428571428572px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRSrProfile/NSF_ApplicationChecklist_1_3:CheckBioSketch"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Current and Pending Support 292.57142857142856px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="292.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRSrProfile/NSF_ApplicationChecklist_1_3:CheckCurrentPendingSupport"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="292.57142857142856px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRSrProfile/NSF_ApplicationChecklist_1_3:CheckCurrentPendingSupport"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Research & Related Personal Data 322.85714285714283px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="322.85714285714283px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="321px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:CheckRRPersonalData"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Research & Related Budget 362.2857142857143px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="362.2857142857143px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="361px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRBudget/NSF_ApplicationChecklist_1_3:CheckRRBudget"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Budget Justification 391.42857142857144px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="391.42857142857144px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRBudget/NSF_ApplicationChecklist_1_3:CheckRRBudgetJustification"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="391.42857142857144px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRBudget/NSF_ApplicationChecklist_1_3:CheckRRBudgetJustification"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="391.42857142857144px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:RRBudget/NSF_ApplicationChecklist_1_3:CheckRRBudgetJustification"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>


               <!-- National Science Foundation Grant Application Cover Sheet 494.85714285714283px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="494.85714285714283px" height="12.571428571428571px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="ZapfDingbats" font-weight="normal"><fo:inline font-family="ZapfDingbats" font-size="10pt">&#x274F;</fo:inline>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="20px" hyphenate="true" language="en" top="493px" height="12px" width="30px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">
                     <xsl:call-template name="checkbox">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFCover"/>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- NSF Unit of Consideration 523.4285714285714px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="523.4285714285714px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFUnit"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="523.4285714285714px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFUnit"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Other Information 552.5714285714286px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="552.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFOtherInfo"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="552.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFOtherInfo"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="552.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFOtherInfo"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>


               <!-- SF LLL, Disclosure of Lobbying Activities 572.5714285714286px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="572.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFSFLLL"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="572.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFSFLLL"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="572.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFSFLLL"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Deviation Authorization 644.5714285714286px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="644.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFDevAuth"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="644.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFDevAuth"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="644.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFDevAuth"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- Organization and Individual Registration for NSF's FastLane system 672.5714285714286px-->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="672.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFReg"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="672.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFReg"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="672.5714285714286px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckNSFReg"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>

               <!-- List of Suggested Reviewers, or Reviewers Not to Include 713.1428571428571px -->
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="42px" hyphenate="true" language="en" top="713.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckDoNotInclude"/>
                        <xsl:with-param name="schemaChoice">Y: Yes</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="60px" hyphenate="true" language="en" top="713.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckDoNotInclude"/>
                        <xsl:with-param name="schemaChoice">N: No</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="78px" hyphenate="true" language="en" top="713.1428571428571px" height="12.571428571428571px" width="20px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica">
                     <xsl:call-template name="radioButton">
                        <xsl:with-param name="value" select="NSF_ApplicationChecklist_1_3:NSFCover/NSF_ApplicationChecklist_1_3:CheckDoNotInclude"/>
                        <xsl:with-param name="schemaChoice">NA: Not Applicable</xsl:with-param>
                     </xsl:call-template>
                  </fo:block>
               </fo:block-container>


               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="31.428571428571427px" hyphenate="true" language="en" top="391.42857142857144px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="21.714285714285715px" height="12.571428571428571px" width="140px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Bibliography and References Cited:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="2.2857142857142856px" hyphenate="true" language="en" top="0.5714285714285714px" height="12.571428571428571px" width="137.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="7pt" font-style="normal" font-family="Helvetica" font-weight="bold">CHECK SECTION COMPLETED</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="178px" hyphenate="true" language="en" top="21.714285714285715px" height="12.571428571428571px" width="380px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">No page limitation, however, this section must include bibliographic citations only and must not be used to </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="60.57142857142857px" height="12.571428571428571px" width="130px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Facilities and Other Resources: </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="162px" hyphenate="true" language="en" top="60.57142857142857px" height="12.571428571428571px" width="377.14285714285717px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Attach in Block 9 to the Research &amp; Related Other Project Information Form.  See GPG Chapter II.C.2.i, </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="68.57142857142857px" height="12.571428571428571px" width="240px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Facilities, Equipment and Other Resources, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="97.71428571428571px" height="12.571428571428571px" width="140px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Other Resources, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="88px" height="12.571428571428571px" width="44.57142857142857px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Equipment:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="87px" hyphenate="true" language="en" top="88px" height="12.571428571428571px" width="470px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Attach in Block 10 to the Research &amp; Related Other Project Information Form.  See GPG Chapter II.C.2.i, Facilities, Equipment and</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.42857142857143px" hyphenate="true" language="en" top="130.28571428571428px" height="12.571428571428571px" width="215px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Special Information and Supplementary Documentation: </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="312px" hyphenate="true" language="en" top="130.28571428571428px" height="12.571428571428571px" width="260px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">A description of the types of information appropriate for inclusion in this</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.42857142857143px" hyphenate="true" language="en" top="138.28571428571428px" height="24.571428571428573px" width="446.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">section is defined in GPG Chapter II.C.2.j, Special Information and Supplementary Documentation.  Attach in Block 11 of the Research &amp; Related Other Project Information Form.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.42857142857143px" hyphenate="true" language="en" top="169.71428571428572px" height="12.571428571428571px" width="275px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Any additional items specified in a relevant NSF Program Solicitation:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="363px" hyphenate="true" language="en" top="169.71428571428572px" height="12.571428571428571px" width="201.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Attach in Block 11 of the Research &amp; Related Other </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="95.42857142857143px" hyphenate="true" language="en" top="177.71428571428572px" height="12.571428571428571px" width="136px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Project Information Form.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="39.42857142857143px" hyphenate="true" language="en" top="116px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="56.57142857142857px" hyphenate="true" language="en" top="116px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="73.71428571428571px" hyphenate="true" language="en" top="116px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96px" hyphenate="true" language="en" top="249.71428571428572px" height="12.571428571428571px" width="107.42857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Biographical Sketch(es):</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="192px" hyphenate="true" language="en" top="249.71428571428572px" height="12.571428571428571px" width="380px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">A biographical sketch is required for all senior project personnel and each biographical sketch should be</fo:block>
               </fo:block-container>
               
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96px" hyphenate="true" language="en" top="258px" height="26.285714285714285px" width="460px">
			 <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">prepared in accordance with the order and format specifications identified in GPG Chapter II.C.2.f, Biographical Sketch(es).  Note limitation of 2-pages for each biographical sketch.</fo:block>

               </fo:block-container>
               
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="196.57142857142858px" height="12.571428571428571px" width="180px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Research &amp; Related Senior/Key Person Profile:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="221px" hyphenate="true" language="en" top="196.57142857142858px" height="12.571428571428571px" width="319.42857142857144px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">A profile is required for all senior/key person proposed.  Unless otherwise specified in an</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="205.14285714285714px" height="24.571428571428573px" width="496px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">agency announcement, Senior/Key Personnel are defined as all individuals who contribute in a substantive, measurable way to the scientific development or execution of the project, whether or not salaries are requested.  Consultants should be included if they meet this definition.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96px" hyphenate="true" language="en" top="292.57142857142856px" height="12.571428571428571px" width="114.85714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Current and Pending Support:</fo:block>
               </fo:block-container>
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="213px" hyphenate="true" language="en" top="292.57142857142856px" height="12.571428571428571px" width="340px">
			   <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">This section is required for all senior project personnel.  See GPG Chapter II.C.2.h, Current and </fo:block>
               </fo:block-container>
               
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96px" hyphenate="true" language="en" top="302.85714285714283px" height="12.571428571428571px" width="429.7142857142857px">
			   <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Pending Support, for more information.</fo:block>
               </fo:block-container>
               
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="322.85714285714283px" height="12.571428571428571px" width="133.71428571428572px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Research &amp; Related Personal Data:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="175px" hyphenate="true" language="en" top="322.85714285714283px" height="12.571428571428571px" width="400px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">(Referred to in the GPG as Information About PIs/PDs and co-PIs/co-PDs.)  With the exception of the name(s)</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="331.42857142857144px" height="23.428571428571427px" width="500px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">of the PD/PI and any co-PD/PIs, submission of the requested information is voluntary.  See GPG Chapter II.C.1.a, Information about Principal Investigators/Project Directors and co-Principal Investigators/co-Project Directors, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96px" hyphenate="true" language="en" top="391.42857142857144px" height="12.571428571428571px" width="85px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Budget Justification: </fo:block>
               </fo:block-container>
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="177px" hyphenate="true" language="en" top="391.42857142857144px" height="12.571428571428571px" width="400.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Optional. Note 3-page limitation per application.  Attach on Line K of the Research &amp; Related Budget Form.</fo:block>
               </fo:block-container>
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40.57142857142857px" hyphenate="true" language="en" top="362.2857142857143px" height="12.571428571428571px" width="136px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Research &amp; Related Budget</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="39.42857142857143px" hyphenate="true" language="en" top="376.57142857142856px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="56.57142857142857px" hyphenate="true" language="en" top="376.57142857142856px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="73.71428571428571px" hyphenate="true" language="en" top="376.57142857142856px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="13.714285714285714px" hyphenate="true" language="en" top="460px" height="12.571428571428571px" width="96px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NSF-Specific Forms</fo:block>
               </fo:block-container>

               <!--Line-->
				<fo:block-container background-color="transparent" border-style="none" position="absolute" left="15.428571428571429px" hyphenate="true" language="en" top="463px" height="2px" width="550px">
                  <fo:block><fo:leader leader-length="100%" leader-pattern="rule" rule-style="solid" rule-thickness="0.5px" /></fo:block>
               </fo:block-container>  
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="523.4285714285714px" height="12.571428571428571px" width="115px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NSF Unit of Consideration:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="552.5714285714286px" height="12.571428571428571px" width="70.85714285714286px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Other Information: </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="200px" hyphenate="true" language="en" top="523.4285714285714px" height="12.571428571428571px" width="350px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">See <fo:inline font-weight="bold" color="#0000ff">https://fastlane.nsf.gov/pgmannounce.jsp</fo:inline> and follow the instructions for finding the Division</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="168px" hyphenate="true" language="en" top="552.5714285714286px" height="12.571428571428571px" width="362.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If the application includes any of the items listed, check the relevant box(es). (Block 5)</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="533.7142857142857px" height="12.571428571428571px" width="430.85714285714283px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">and Program Information for the funding opportunity shown in Block 1.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="38.285714285714285px" hyphenate="true" language="en" top="494.85714285714283px" height="12.571428571428571px" width="246.28571428571428px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">National Science Foundation Grant Application Cover Sheet</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="2.2857142857142856px" hyphenate="true" language="en" top="476.57142857142856px" height="12.571428571428571px" width="137.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="7pt" font-style="normal" font-family="Helvetica" font-weight="bold">CHECK SECTION COMPLETED</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="39.42857142857143px" hyphenate="true" language="en" top="509.14285714285717px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="56.57142857142857px" hyphenate="true" language="en" top="509.14285714285717px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="73.71428571428571px" hyphenate="true" language="en" top="509.14285714285717px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="572.5714285714286px" height="12.571428571428571px" width="165px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">SF LLL, Disclosure of Lobbying Activities:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="582.8571428571429px" height="12.571428571428571px" width="270px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Application Cover Sheet. See GPG Chapter II.C.1.e, Proposal Certifications.</fo:block>
               </fo:block-container>
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="260px" hyphenate="true" language="en" top="572.5714285714286px" height="12.571428571428571px" width="280px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If applicable.  Attach a scanned copy of the SF LLL in Block 6 of the NSF Grant</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="96.57142857142857px" hyphenate="true" language="en" top="644.5714285714286px" height="12.571428571428571px" width="100px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Deviation Authorization: </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="192px" hyphenate="true" language="en" top="644.5714285714286px" height="12.571428571428571px" width="330.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If applicable.  See GPG Chapter II.C.1.b, Deviation Authorization, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="97.14285714285714px" hyphenate="true" language="en" top="672.5714285714286px" height="12.571428571428571px" width="270px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Organization and Individual Registration for NSF's FastLane system:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="360px" hyphenate="true" language="en" top="672.5714285714286px" height="12.571428571428571px" width="201.14285714285714px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">If applicable.  To be completed only if the applicant </fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="97.14285714285714px" hyphenate="true" language="en" top="682.2857142857143px" height="12.571428571428571px" width="450px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">organization is not currently registered in NSF's FastLane system.  See <fo:inline font-weight="bold" color="#0000ff">https://www.fastlane.nsf.gov/b6/B6Institutions.htm.</fo:inline></fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="39.42857142857143px" hyphenate="true" language="en" top="630.2857142857143px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="56.57142857142857px" hyphenate="true" language="en" top="630.2857142857143px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="73.71428571428571px" hyphenate="true" language="en" top="630.2857142857143px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">NA</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="97.14285714285714px" hyphenate="true" language="en" top="713.1428571428571px" height="12.571428571428571px" width="230px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">List of Suggested Reviewers, or Reviewers Not to Include:</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="324px" hyphenate="true" language="en" top="713.1428571428571px" height="12.571428571428571px" width="247.42857142857142px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Optional.  See GPG Chapter II.C.1.c, List of Suggested Reviewers or</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="97.14285714285714px" hyphenate="true" language="en" top="721.1428571428571px" height="24.571428571428573px" width="470px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Reviewers Not to Include (optional).  GPG Appendix B, Potentially Disqualifying Conflicts of Interest, contains information on conflicts of interest that may be useful in preparation of this list. </fo:block>
               </fo:block-container>
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32.57142857142857px" hyphenate="true" language="en" top="523px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32px" hyphenate="true" language="en" top="553.7142857142857px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               
               
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="32.57142857142857px" hyphenate="true" language="en" top="573.7142857142857px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>

               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.714285714285715px" hyphenate="true" language="en" top="646.2857142857143px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.714285714285715px" hyphenate="true" language="en" top="673.1428571428571px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.714285714285715px" hyphenate="true" language="en" top="714.2857142857143px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="33.142857142857146px" hyphenate="true" language="en" top="170.28571428571428px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="30.857142857142858px" hyphenate="true" language="en" top="129.71428571428572px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="40px" hyphenate="true" language="en" top="32px" height="21.714285714285715px" width="494.2857142857143px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">provide parenthetical information outside of the 15-page Project Narrative.  Each reference must be in the specified format.  Attach in Block 8 of the Research &amp; Related Other Project Information Form. See GPG Chapter II.C.2.e, References Cited, for more information.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="39.42857142857143px" hyphenate="true" language="en" top="236px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">Yes</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="56.57142857142857px" hyphenate="true" language="en" top="236px" height="12.571428571428571px" width="16px">
                  <fo:block background-color="transparent" color="#000000" text-align="center" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="bold">No</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="31.428571428571427px" hyphenate="true" language="en" top="251.42857142857142px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="21.714285714285715px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="60.57142857142857px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="31.428571428571427px" hyphenate="true" language="en" top="293.14285714285717px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="97.14285714285714px" hyphenate="true" language="en" top="692.5714285714286px" height="12.571428571428571px" width="428px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">Individuals not employed by, or affiliated with, an organization must complete the information in Section 3.</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="88px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="196.57142857142858px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="322.85714285714283px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="362.2857142857143px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
               <fo:block-container background-color="transparent" border-style="none" position="absolute" left="8px" hyphenate="true" language="en" top="494.85714285714283px" height="13.714285714285714px" width="8px">
                  <fo:block background-color="transparent" color="#000000" font-size="8pt" font-style="normal" font-family="Helvetica" font-weight="normal">*</fo:block>
               </fo:block-container>
              
               
            </fo:flow>
         </fo:page-sequence>
      </fo:root>
   </xsl:template>
   <xsl:template name="radioButton">
      <xsl:param name="value"/>
      <xsl:param name="schemaChoice">Y: Yes</xsl:param>
      <xsl:choose>
         <xsl:when test="$value = $schemaChoice">
            <fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="10pt">&#x25cf;</fo:inline>
         </xsl:when>
         <xsl:otherwise>
            <fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="10pt">&#x274d;</fo:inline>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template name="checkbox">
      <xsl:param name="value"/>
      <xsl:param name="schemaChoice">Y: Yes</xsl:param>
      <xsl:if test="$value = $schemaChoice">
         <fo:inline xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" font-family="ZapfDingbats" font-size="11pt">&#x2714;</fo:inline>
      </xsl:if>
   </xsl:template>
   <xsl:template name="formatDate">
      <xsl:param name="value"/>
      <xsl:if test="$value != ''">
         <xsl:value-of select="format-number(substring($value,6,2), '00')"/>
         <xsl:text>/</xsl:text>
         <xsl:value-of select="format-number(substring($value,9,2), '00')"/>
         <xsl:text>/</xsl:text>
         <xsl:value-of select="format-number(substring($value,1,4), '0000')"/>
      </xsl:if>
   </xsl:template>
   <xsl:template name="addBlankLines">
      <xsl:param name="numLines"/>
      <xsl:if test="string($numLines) != ''">
         <xsl:if test="$numLines &gt; 0">
            <fo:block xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:footer="http://apply.grants.gov/system/Footer-V1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:glob="http://apply.grants.gov/system/Global-V1.0">
               <fo:leader leader-pattern="space"/>
            </fo:block>
            <xsl:call-template name="addBlankLines">
               <xsl:with-param name="numLines" select="$numLines - 1"/>
            </xsl:call-template>
         </xsl:if>
      </xsl:if>
   </xsl:template>
</xsl:stylesheet>
