<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:PHS398_CoverPageSupplement_2_0="http://apply.grants.gov/forms/PHS398_CoverPageSupplement_2_0-V2.0" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
				<fo:region-before extent="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="PHS398_CoverPageSupplement_2_0:PHS398_CoverPageSupplement_2_0">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="headerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-size="small" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Vrinda" font-size="smaller" table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="15%"/>
													<fo:table-column column-width="85%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row line-height="normal">
															<fo:table-cell font-size="small" number-columns-spanned="2" padding="0" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>1. Project Director / Principal Investigator (PD/PI)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-size="small" padding-left="5pt" padding="0" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Prefix:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table margin-bottom="2pt" padding-left="2pt" table-layout="fixed" width="50%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="0" border-bottom-style="none" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPI">
																								<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPIName">
																									<xsl:for-each select="globLib:PrefixName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-size="small" padding-left="5pt" padding="0" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*First Name:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table margin-bottom="2pt" padding-left="2pt" table-layout="fixed" width="75%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="0" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPI">
																								<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPIName">
																									<xsl:for-each select="globLib:FirstName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-size="small" padding-left="5pt" padding="0" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Middle Name:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table margin-bottom="2pt" padding-left="2pt" table-layout="fixed" width="65%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="0" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPI">
																								<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPIName">
																									<xsl:for-each select="globLib:MiddleName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-size="small" padding-left="5pt" padding="0" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Last Name:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table margin-bottom="2pt" padding-left="2pt" table-layout="fixed" width="90%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="0" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPI">
																								<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPIName">
																									<xsl:for-each select="globLib:LastName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell font-size="small" padding-left="5pt" padding="0" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Suffix:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" padding="0" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table margin-bottom="2pt" padding-left="2pt" table-layout="fixed" width="50%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="0" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPI">
																								<xsl:for-each select="PHS398_CoverPageSupplement_2_0:PDPIName">
																									<xsl:for-each select="globLib:SuffixName">
																										<xsl:variable name="value-of-template">
																											<xsl:apply-templates/>
																										</xsl:variable>
																										<xsl:choose>
																											<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																												<fo:block>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:block>
																											</xsl:when>
																											<xsl:otherwise>
																												<fo:inline>
																													<xsl:copy-of select="$value-of-template"/>
																												</fo:inline>
																											</xsl:otherwise>
																										</xsl:choose>
																									</xsl:for-each>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Arial" font-size="small" table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="40%"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>2. Human Subjects</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Clinical Trial?</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell font-size="small" number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:ClinicalTrial">
																			<xsl:for-each select="PHS398_CoverPageSupplement_2_0:isClinicalTrial">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='N: No'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>No</xsl:text>
																				</fo:inline>
																				<fo:inline>
																					<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:choose>
																					<xsl:when test="string(.)='Y: Yes'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>Yes</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Agency-Defined Phase III Clinical Trial?</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:ClinicalTrial">
																			<xsl:for-each select="PHS398_CoverPageSupplement_2_0:isPhaseIIIClinicalTrial">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='N: No'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>No</xsl:text>
																				</fo:inline>
																				<fo:inline>
																					<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:choose>
																					<xsl:when test="string(.)='Y: Yes'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>Yes</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Verdana" font-size="small" table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>3. *Disclosure Permission Statement</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row padding-left="10pt" padding-right="15pt">
															<fo:table-cell padding-left="25pt" padding-right="50pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>If this application does not result in an award, is the Government permitted to disclose the title of your proposed project, and the name, address, telephone number and e-mail address of the official signing for the applicant organization, to organizations that may be interested in contacting you for further information (e.g., possible collaborations, investment)?</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="75pt" padding="2pt" display-align="center">
																<fo:block>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:DisclosurePermission">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																			<fo:inline>
																				<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			</fo:inline>
																			<xsl:choose>
																				<xsl:when test="string(.)='N: No'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="0" height="17" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table border-top-style="none" font-family="Verdana" font-size="small" table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row border-top-style="none">
															<fo:table-cell border-bottom-style="none" border-top-style="none" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>4. *Program Income</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>&#160; </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-style="none" border-top-style="none" padding-left="25pt" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Is program income anticipated during the periods for which the grant support is requested?</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-bottom-style="none" border-top-style="none" padding-left="75pt" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:ProgramIncome">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																			<fo:inline>
																				<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			</fo:inline>
																			<xsl:choose>
																				<xsl:when test="string(.)='N: No'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																	</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-left="25pt" padding-right="50pt" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>If you checked &quot;yes&quot; above (indicating that program income is anticipated), then use the format below to reflect the amount and source(s). Otherwise, leave this section blank.</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-left="5pt" padding-right="5pt" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="12%"/>
																		<fo:table-column column-width="20%"/>
																		<fo:table-column column-width="68%"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-size="8pt" font-weight="bold">
																							<xsl:text>*Budget Period</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-size="8pt" font-weight="bold">
																							<xsl:text>*Anticipated Amount($)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
																					<fo:block>
																						<fo:inline font-size="8pt" font-weight="bold">
																							<xsl:text>*Source(s)</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[1]/PHS398_CoverPageSupplement_2_0:BudgetPeriod"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" height="10%" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[1]/PHS398_CoverPageSupplement_2_0:AnticipatedAmount"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[1]/PHS398_CoverPageSupplement_2_0:Source"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[2]/PHS398_CoverPageSupplement_2_0:BudgetPeriod"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" height="10%" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[2]/PHS398_CoverPageSupplement_2_0:AnticipatedAmount"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[2]/PHS398_CoverPageSupplement_2_0:Source"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[3]/PHS398_CoverPageSupplement_2_0:BudgetPeriod"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" height="10%" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[3]/PHS398_CoverPageSupplement_2_0:AnticipatedAmount"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[3]/PHS398_CoverPageSupplement_2_0:Source"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[4]/PHS398_CoverPageSupplement_2_0:BudgetPeriod"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" height="10%" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[4]/PHS398_CoverPageSupplement_2_0:AnticipatedAmount"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[4]/PHS398_CoverPageSupplement_2_0:Source"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[5]/PHS398_CoverPageSupplement_2_0:BudgetPeriod"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" height="10%" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[5]/PHS398_CoverPageSupplement_2_0:AnticipatedAmount"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:IncomeBudgetPeriod[5]/PHS398_CoverPageSupplement_2_0:Source"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell border-top-style="none" padding-left="25pt" padding-right="50pt" number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block break-after="page">
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-size="small" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Verdana" font-size="small" table-layout="fixed" width="100%" border-spacing="0">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>5. Human Embryonic Stem Cells</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Does the proposed project involve human embryonic stem cells?&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:StemCells">
																			<xsl:for-each select="PHS398_CoverPageSupplement_2_0:isHumanStemCellsInvolved">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='N: No'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>No</xsl:text>
																				</fo:inline>
																				<fo:inline>
																					<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																				</fo:inline>
																				<xsl:choose>
																					<xsl:when test="string(.)='Y: Yes'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																				<fo:inline>
																					<xsl:text>&#160;</xsl:text>
																				</fo:inline>
																				<fo:inline font-size="smaller">
																					<xsl:text>Ye</xsl:text>
																				</fo:inline>
																			</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>If the proposed project involves human embryonic stem cells, list below the registration number of the specific cell line(s) from the following list:http://stemcells.nih.gov/research/registry/. Or, if a specific stem cell line cannot be referenced at this time, please check the box indicating that one from the registry will be used:</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-left="5pt" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Cell Line(s):&#160; </xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:StemCells">
																			<xsl:for-each select="PHS398_CoverPageSupplement_2_0:StemCellsIndicator">
																				<xsl:choose>
																					<xsl:when test="string(.)='true'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:when test="string(.)='Y: Yes'">
																						<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																							<xsl:text>&#x2714;</xsl:text>
																						</fo:inline>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline border="solid 1pt black">
																							<fo:leader leader-length="10pt" leader-pattern="space"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																		<fo:inline>
																		<xsl:text>&#160;&#160;&#160; Specific stem cell line cannot be referenced at this time. One from the registry will be used.</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[1]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[2]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[3]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[4]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[5]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[6]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[7]"/>
																						</fo:inline>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[8]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[9]"/>
																						</fo:inline>
																						<fo:inline>
																							<xsl:text>&#160; </xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[10]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[11]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[12]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[13]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[14]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[15]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[16]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[17]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[18]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[19]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[20]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[21]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[22]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[23]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[24]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[25]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[26]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[27]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[28]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[29]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[30]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[31]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[32]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[33]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[34]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[35]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[36]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[37]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[38]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[39]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[40]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[41]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[42]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[43]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[44]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[45]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[46]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[47]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[48]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[49]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[50]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[51]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[52]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[53]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[54]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[55]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[56]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[57]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[58]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[59]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[60]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[61]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[62]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[63]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[64]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[65]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[66]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[67]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[68]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[69]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[70]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[71]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[72]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[73]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[74]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[75]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[76]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[77]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[78]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[79]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[80]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[81]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[82]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[83]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[84]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[85]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[86]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[87]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[88]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[89]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[90]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[91]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[92]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[93]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[94]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[95]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[96]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[97]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[98]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[99]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[100]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[101]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[102]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[103]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[104]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[105]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[106]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[107]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[108]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[109]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[110]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[111]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[112]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[113]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[114]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[115]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[116]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[117]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[118]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[119]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[120]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[121]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[122]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[123]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[124]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[125]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[126]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[127]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[128]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[129]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[130]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[131]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[132]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[133]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[134]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[135]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[136]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[137]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[138]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[139]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[140]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[141]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[142]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[143]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[144]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[145]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[146]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[147]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[148]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[149]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[150]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[151]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[152]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[153]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[154]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[155]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[156]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[157]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[158]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[159]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[160]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[161]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[162]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[163]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[164]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[165]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[166]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[167]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[168]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[169]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[170]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[171]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[172]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[173]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[174]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[175]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[176]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[177]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[178]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[179]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[180]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[181]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[182]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[183]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[184]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[185]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[186]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[187]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[188]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[189]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[190]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[191]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[192]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[193]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[194]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[195]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[196]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[197]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[198]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[199]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="PHS398_CoverPageSupplement_2_0:StemCells/PHS398_CoverPageSupplement_2_0:CellLines[200]"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-left="5pt" border="solid 1pt gray" padding="2pt" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table font-family="Verdana" font-size="small" table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="proportional-column-width(1)"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>6. Inventions and Patents (For renewal applications only)</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>*Inventions and Patents:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:IsInventionsAndPatents">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																			<fo:inline>
																				<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			</fo:inline>
																			<xsl:choose>
																				<xsl:when test="string(.)='N: No'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160; </xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text> If the answer is &quot;Yes&quot; then please answer the following:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>*Previously Reported:&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																	</fo:inline>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:IsPreviouslyReported">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>Yes</xsl:text>
																			</fo:inline>
																			<fo:inline>
																				<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																			</fo:inline>
																			<xsl:choose>
																				<xsl:when test="string(.)='N: No'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																			<fo:inline>
																				<xsl:text>&#160;</xsl:text>
																			</fo:inline>
																			<fo:inline font-size="smaller">
																				<xsl:text>No</xsl:text>
																			</fo:inline>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block break-after="page">
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Verdana" font-size="small" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="8%"/>
													<fo:table-column column-width="20%"/>
													<fo:table-column column-width="72%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline font-weight="bold">
																		<xsl:text>7. Change of Investigator / Change of Institution Questions</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:block/>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:IsChangeOfPDPI">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>Change of principal investigator / program director</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Name of former principal investigator / program director:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Prefix:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="80%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerPD_Name">
																								<xsl:for-each select="globLib:PrefixName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*First Name:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="80%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerPD_Name">
																								<xsl:for-each select="globLib:FirstName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Middle Name:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="80%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerPD_Name">
																								<xsl:for-each select="globLib:MiddleName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Last Name</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="80%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerPD_Name">
																								<xsl:for-each select="globLib:LastName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>Suffix:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="80%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerPD_Name">
																								<xsl:for-each select="globLib:SuffixName">
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</xsl:for-each>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" text-align="right" display-align="center">
																<fo:block>
																	<fo:block/>
																		<xsl:for-each select="PHS398_CoverPageSupplement_2_0:IsChangeOfInstitution">
																			<xsl:choose>
																				<xsl:when test="string(.)='true'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:when test="string(.)='Y: Yes'">
																					<fo:inline border="solid 1pt black" font-family="ZapfDingbats" font-size="10pt ">
																						<xsl:text>&#x2714;</xsl:text>
																					</fo:inline>
																				</xsl:when>
																				<xsl:otherwise>
																					<fo:inline border="solid 1pt black">
																						<fo:leader leader-length="10pt" leader-pattern="space"/>
																					</fo:inline>
																				</xsl:otherwise>
																			</xsl:choose>
																		</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<fo:block/>
																	<fo:inline>
																		<xsl:text>Change of Grantee Institution</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>*Name of former institution:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table table-layout="fixed" width="95%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>&#160;</xsl:text>
																						</fo:inline>
																							<xsl:for-each select="PHS398_CoverPageSupplement_2_0:FormerInstitutionName">
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="headerall">
		<fo:static-content flow-name="xsl-region-before">
			<fo:block>
				<fo:inline-container>
					<fo:block>
						<xsl:text>&#x2029;</xsl:text>
					</fo:block>
				</fo:inline-container>
				<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="150"/>
					<fo:table-body start-indent="0pt">
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" height="30" text-align="left" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell font-size="10pt" padding="0" height="10" text-align="left" display-align="center">
								<fo:block>
									<fo:inline font-size="large" font-weight="bold">
										<xsl:text>PHS 398 Cover Page Supplement</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell font-size="10pt" padding="0" height="10" text-align="right" display-align="center">
								<fo:block>
									<fo:inline font-size="xx-small">
										<xsl:text>OMB Number: 0925-0001</xsl:text>
									</fo:inline>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
