<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2014 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:PHS398_TrainingBudget_2_0="http://apply.grants.gov/forms/PHS398_TrainingBudget_2_0-V2.0" xmlns:PHS398_TrainingSubawardBudget_3_0="http://apply.grants.gov/forms/PHS398_TrainingSubawardBudget_3_0-V3.0.xsd" xmlns:att="http://apply.grants.gov/system/Attachments-V1.0" xmlns:codes="http://apply.grants.gov/system/UniversalCodes-V2.0" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:glob="http://apply.grants.gov/system/Global-V1.0" xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0" xmlns:n1="http://apply.grants.gov/forms/PHS398_TrainingSubawardBudget_3_0-V3.0" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
				<fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>

	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">

				<fo:flow flow-name="xsl-region-body">
					<fo:table width="100%">
						<fo:table-column column-width="0.2in"/>
						<fo:table-column/>
						<fo:table-column column-width="0.2in"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell width="0.2in"><fo:block>&#160;</fo:block></fo:table-cell>
								<fo:table-cell width="7.0in">
									<fo:block text-align="center" font-family="Helvetica,Times,Courier" font-size="11pt" font-weight="bold">TRAINING SUBAWARD BUDGET ATTACHMENT(S) FORM                              </fo:block>
									<fo:block>&#160;</fo:block>
									<fo:block font-size="8pt" hyphenate="true" language="en">
										<fo:inline font-weight="bold" font-size="8pt">Instructions:</fo:inline>
										This form allows you to attach a PHS 398 Training Budget form for each subaward/consortium associated with your application. Use the "Click here to extract the PHS 398 Training Subaward Attachment" button to extract a blank copy of the PHS 398 Training Budget form, complete the form in accordance with the agency instructions, and attach the completed form using one of the "Add Attachment" buttons.
									</fo:block>
									<fo:block line-height="4pt">&#160;</fo:block>
									<fo:block>&#160;</fo:block>
									<fo:block>&#160;</fo:block>
									<fo:block font-size="8pt" hyphenate="true" language="en">
										<fo:inline font-weight="bold" font-size="8pt">Important:</fo:inline>
										Attach Training Subaward Budget forms, using the blocks below. Remember that the files you attach must be PHS 398 Training Budget PDF forms, which were previously extracted using the process outlined above. Attaching any other type of file may result in the inability to submit your application to Grants.gov.
									</fo:block>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
								<fo:table-cell width="0.2in"><fo:block>&#160;</fo:block></fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<fo:table width="100%">
						<fo:table-column/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
									<fo:block>&#160;</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT1!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															1) Please attach Attachment 1

														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT1" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT2!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															2) Please attach Attachment 2

														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT2" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT3!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															3) Please attach Attachment 3

														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT3" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT4!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															4) Please attach Attachment 4

														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT4" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT5!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															5) Please attach Attachment 5

														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT5" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT6!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															6) Please attach Attachment 6
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT6" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT7!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															7) Please attach Attachment 7
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT7" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT8!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															8) Please attach Attachment 8
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT8" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT9!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															9) Please attach Attachment 9
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT9" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
							<xsl:if test="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT10!=''">
								<fo:table-row>
									<fo:table-cell>
										<fo:table width="100%">
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-weight">bold</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															10) Please attach Attachment 10
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<xsl:attribute name="line-height">15pt</xsl:attribute>
														<xsl:attribute name="hyphenate">true</xsl:attribute>
														<xsl:attribute name="font-size">8pt</xsl:attribute>
														<fo:block>
															<xsl:value-of select="//n1:PHS398_TrainingSubawardBudget_3_0/n1:ATT10" />
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</fo:table-cell>
								</fo:table-row>
							</xsl:if>
						</fo:table-body>
					</fo:table>
				</fo:flow>
			</fo:page-sequence>
			<fo:page-sequence master-reference="default-page" initial-page-number="2" format="1">
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<fo:inline-container>
							<fo:block>
								<xsl:text>&#x2029;</xsl:text>
							</fo:block>
						</fo:inline-container>
						<xsl:if test="$XML/n1:PHS398_TrainingSubawardBudget_3_0/n1:BudgetAttachments/PHS398_TrainingBudget_2_0:PHS398_TrainingBudget_2_0">
							<fo:table table-layout="fixed" width="100%" border-spacing="0">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<xsl:for-each select="$XML">
										<xsl:for-each select="n1:PHS398_TrainingSubawardBudget_3_0">
											<xsl:for-each select="n1:BudgetAttachments">
												<xsl:for-each select="PHS398_TrainingBudget_2_0:PHS398_TrainingBudget_2_0">
													<fo:table-row>
														<fo:table-cell padding="0" display-align="center">
															<fo:block>
																<xsl:if test="position() &gt;1">
																	<fo:block break-after="page">
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																</xsl:if>
																<fo:block/>
																<xsl:for-each select="PHS398_TrainingBudget_2_0:BudgetYear">
																	<fo:table font-family="arialuni" line-height="11px" padding="0" table-layout="fixed" width="100%" border-spacing="0pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body margin="0" padding="0" start-indent="0pt">
																			<fo:table-row margin="0">
																				<fo:table-cell margin="0" padding="0" padding-bottom="0" display-align="center">
																					<fo:block text-align="right">
																						<fo:inline font-size="6px">
																							<xsl:text>OMB Number: 0925-0001</xsl:text>
																						</fo:inline>
																					</fo:block>
																					<fo:block text-align="right">
																						<fo:inline font-size="6px">
																							<xsl:text>Expiration Date: 09/30/2024</xsl:text>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row margin="0">
																				<fo:table-cell margin="0" padding="0" padding-top="0" text-align="center" display-align="after">
																					<fo:block>
																						<fo:inline font-family="arialuni" font-size="12px" font-weight="bold">
																							<xsl:text>PHS 398 TRAINING BUDGET, Period </xsl:text>
																						</fo:inline>
																						<fo:inline font-family="arialuni" font-size="12px" font-weight="bold">
																							<xsl:value-of select="position()"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row margin="0">
																				<fo:table-cell padding-left="25pt" padding-right="25pt" padding="1px" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table font-family="Verdana" font-size="7pt" table-layout="fixed" width="100%" border-spacing="2pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body margin="0" padding="0" start-indent="0pt">
																			<fo:table-row margin="0">
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-family="Verdana" font-size="7pt">
																							<xsl:text>Organizational DUNS: </xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="../PHS398_TrainingBudget_2_0:DUNSNumber"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Budget Type: </xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="../PHS398_TrainingBudget_2_0:BudgetType"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row margin="0">
																				<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																					<fo:block>
																						<fo:inline font-family="Verdana" font-size="7pt">
																							<xsl:text>Organization Name: </xsl:text>
																						</fo:inline>
																						<fo:inline>
																							<xsl:value-of select="../PHS398_TrainingBudget_2_0:OrganizationName"/>
																						</fo:inline>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																			<fo:table-row line-height="3pt" margin="0" padding="0" padding-bottom="0" padding-top="0">
																				<fo:table-cell padding="2pt" display-align="before">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>Start Date:</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="PHS398_TrainingBudget_2_0:PeriodStartDate">
																							<fo:inline>
																								<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="before">
																					<fo:block>
																						<fo:inline>
																							<xsl:text>End Date:</xsl:text>
																						</fo:inline>
																						<xsl:for-each select="PHS398_TrainingBudget_2_0:PeriodEndDate">
																							<fo:inline>
																								<xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
																							</fo:inline>
																							<xsl:variable name="value-of-template">
																								<xsl:apply-templates/>
																							</xsl:variable>
																							<xsl:choose>
																								<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																									<fo:block>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:block>
																								</xsl:when>
																								<xsl:otherwise>
																									<fo:inline>
																										<xsl:copy-of select="$value-of-template"/>
																									</fo:inline>
																								</xsl:otherwise>
																							</xsl:choose>
																						</xsl:for-each>
																					</fo:block>
																				</fo:table-cell>
																				<fo:table-cell padding="2pt" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																	<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body start-indent="0pt">
																			<fo:table-row>
																				<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																					<fo:block>
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:table font-family="Verdana" font-size="7pt" table-layout="fixed" width="100%" border-spacing="0">
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-column column-width="proportional-column-width(1)"/>
																							<fo:table-body start-indent="0pt">
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>A. Stipends, Tuition/Fees</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline text-decoration="underline">
																												<xsl:text>Number of Trainees</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Full</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Time</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Short</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Term</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Stipends</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Requested ($)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Tuition/Fees</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Requested ($)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateNumFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateNumShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline text-decoration="underline">
																												<xsl:text>Undergraduate:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Number Per Stipend Level:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>First-Year/Soph.</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateNumFirstYearSophomoreStipends">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Junior/Senior</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:UndergraduateNumJuniorSeniorStipends">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocSingleDegreeNumFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocSingleDegreeNumShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Predoctoral:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Single Degree</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocSingleDegreeStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocSingleDegreeTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocDualDegreeNumFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocDualDegreeNumShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Dual Degree</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocDualDegreeStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocDualDegreeTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocTotalNumFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocTotalNumShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Total Predoctoral</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocTotalStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PredocTotalTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline text-decoration="underline">
																												<xsl:text>Postdoctoral:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="5" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Number Per Stipend Level:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>0</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>1</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>2</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>3</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>4</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>5</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>6</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>7</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Non-degree</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Seeking</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel0">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel1">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel2">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel3">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel4">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel5">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel6">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumNonDegreeStipendLevel7">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNonDegreeStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNonDegreeTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Degree</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Seeking</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel0">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel1">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel2">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel3">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel4">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel5">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel6">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocNumDegreeStipendLevel7">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocDegreeStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocDegreeTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Total</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline font-weight="bold">
																												<xsl:text>Postdoctoral</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel0">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel1">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel2">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel3">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel4">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel5">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel6">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendLevel7">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:PostdocTotalTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:OtherNumFullTime">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:OtherNumShortTerm">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline text-decoration="underline">
																												<xsl:text>Other:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:OtherStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:OtherTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Totals:</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalStipendsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalTuitionAndFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="6" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Total Stipends + Tuition/Fees Requested</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalStipendsAndTuitionFeesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:block text-align="center">
																												<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																											</fo:block>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>B. Other Direct Costs</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Funds Requested ($)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Trainee Travel</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TraineeTravelRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Training Related Expenses</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TrainingRelatedExpensesRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:ResearchDirectCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="6" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Consortium Training Costs (if applicable)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:ConsortiumTrainingCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="5" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Total Other Direct Costs Requested</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalOtherDirectCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:block text-align="center">
																												<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																											</fo:block>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="7" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalDirectCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:block text-align="center">
																												<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																											</fo:block>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="before">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>D. Indirect Costs</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; Indirect Cost Type</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="2" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Indirect Cost</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Rate (%)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Indirect Cost</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Base ($)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>Funds</xsl:text>
																											</fo:inline>
																											<fo:block/>
																											<fo:inline>
																												<xsl:text>Requested ($)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>1.</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="10" number-rows-spanned="2" padding="2pt" display-align="before">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostType1">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostRate1">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostBase1">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostFundsRequested1">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" text-align="center" display-align="center">
																										<fo:block>
																											<fo:inline>
																												<xsl:text>2.</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="10" number-rows-spanned="2" padding="2pt" display-align="before">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostType2">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostRate2">
																																	<xsl:variable name="value-of-template">
																																		<xsl:apply-templates/>
																																	</xsl:variable>
																																	<xsl:choose>
																																		<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																			<fo:block>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:block>
																																		</xsl:when>
																																		<xsl:otherwise>
																																			<fo:inline>
																																				<xsl:copy-of select="$value-of-template"/>
																																			</fo:inline>
																																		</xsl:otherwise>
																																	</xsl:choose>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostBase2">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:IndirectCostFundsRequested2">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="6" padding="2pt" text-align="right" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>Total Indirect Costs Requested</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalIndirectCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:block text-align="center">
																												<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																											</fo:block>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="8" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>E. Total Direct and Indirect Costs Requested (C + D)</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell padding="2pt" display-align="center">
																										<fo:block/>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="PHS398_TrainingBudget_2_0:TotalDirectAndIndirectCostsRequested">
																																	<fo:inline>
																																		<xsl:value-of select="format-number(number(string(.)), '#,###,###,###,##0.00')"/>
																																	</fo:inline>
																																</xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="21" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:block text-align="center">
																												<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																											</fo:block>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																								<fo:table-row>
																									<fo:table-cell number-columns-spanned="5" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline font-weight="bold">
																												<xsl:text>F. Budget Justification</xsl:text>
																											</fo:inline>
																										</fo:block>
																									</fo:table-cell>
																									<fo:table-cell number-columns-spanned="16" padding="2pt" display-align="center">
																										<fo:block>
																											<fo:inline-container>
																												<fo:block>
																													<xsl:text>&#x2029;</xsl:text>
																												</fo:block>
																											</fo:inline-container>
																											<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																												<fo:table-column column-width="proportional-column-width(1)"/>
																												<fo:table-body start-indent="0pt">
																													<fo:table-row>
																														<fo:table-cell border="solid 1pt gray" padding="0" display-align="center">
																															<fo:block>
																																<fo:inline>
																																	<xsl:text>&#160;</xsl:text>
																																</fo:inline>
																																<xsl:for-each select="$XML">
																																	<xsl:for-each select="n1:PHS398_TrainingSubawardBudget_3_0">
        																																 <xsl:for-each select="n1:BudgetAttachments">
																																	   <xsl:for-each select="PHS398_TrainingBudget_2_0:PHS398_TrainingBudget_2_0">
																																		<xsl:for-each select="PHS398_TrainingBudget_2_0:BudgetJustification">
																																			<xsl:for-each select="att:FileName">
																																				<xsl:variable name="value-of-template">
																																					<xsl:apply-templates/>
																																				</xsl:variable>
																																				<xsl:choose>
																																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																						<fo:block>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:block>
																																					</xsl:when>
																																					<xsl:otherwise>
																																						<fo:inline>
																																							<xsl:copy-of select="$value-of-template"/>
																																						</fo:inline>
																																					</xsl:otherwise>
																																				</xsl:choose>
																																			</xsl:for-each>
																																		</xsl:for-each>
																																	</xsl:for-each>
																																    </xsl:for-each>
																																</xsl:for-each>
																															     </xsl:for-each>
																															</fo:block>
																														</fo:table-cell>
																													</fo:table-row>
																												</fo:table-body>
																											</fo:table>
																										</fo:block>
																									</fo:table-cell>
																								</fo:table-row>
																							</fo:table-body>
																						</fo:table>
																					</fo:block>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																	<fo:inline font-family="Verdana" font-size="7pt">
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<fo:block break-after="page">
																		<fo:leader leader-pattern="space"/>
																	</fo:block>
																	<fo:inline-container>
																		<fo:block>
																			<xsl:text>&#x2029;</xsl:text>
																		</fo:block>
																	</fo:inline-container>
																	<fo:table line-height="6pt" table-layout="fixed" width="100%" border-spacing="0">
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-column column-width="proportional-column-width(1)"/>
																		<fo:table-body margin="0" padding="0" start-indent="0pt">
																			<fo:table-row margin="0">
																				<fo:table-cell number-columns-spanned="2" padding="0" display-align="center">
																					<fo:block/>
																				</fo:table-cell>
																			</fo:table-row>
																		</fo:table-body>
																	</fo:table>
																</xsl:for-each>
																<fo:block/>
																<fo:inline font-size="medium" font-weight="bold">
																	<xsl:text>PHS 398 TRAINING BUDGET, Cumulative Budget</xsl:text>
																</fo:inline>
																<fo:inline-container>
																	<fo:block>
																		<xsl:text>&#x2029;</xsl:text>
																	</fo:block>
																</fo:inline-container>
																<fo:table font-family="Verdana" font-size="7pt" margin="0" padding="0" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																	<fo:table-column column-width="proportional-column-width(1)"/>
																	<fo:table-body start-indent="0pt">
																		<fo:table-row>
																			<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline-container>
																						<fo:block>
																							<xsl:text>&#x2029;</xsl:text>
																						</fo:block>
																					</fo:inline-container>
																					<fo:table font-family="Verdana" font-size="7pt" padding-left="3pt" table-layout="fixed" width="100%" border-spacing="0">
																						<fo:table-column column-width="5%"/>
																						<fo:table-column column-width="10%"/>
																						<fo:table-column column-width="35%"/>
																						<fo:table-column column-width="25%"/>
																						<fo:table-column column-width="25%"/>
																						<fo:table-body font-family="verdana" font-size="7pt" start-indent="0pt">
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>A. Stipends, Tuition/Fees</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" text-align="center" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Stipends</xsl:text>
																										</fo:inline>
																										<fo:block/>
																										<fo:inline font-size="7pt">
																											<xsl:text>Requested ($)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" text-align="center" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Tuition/Fees</xsl:text>
																										</fo:inline>
																										<fo:block/>
																										<fo:inline font-size="7pt">
																											<xsl:text>Requested ($)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row font-family="Verdana" font-size="7pt" font-style="inherit">
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="2" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Undergraduate:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="Verdana" font-size="7pt" font-style="inherit" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body font-family="verdana" font-size="7pt" font-style="inherit" start-indent="0pt">
																												<fo:table-row font-family="verdana" font-size="7pt" font-style="inherit">
																													<fo:table-cell font-family="Verdana" font-size="7 pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeUndergraduateStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body font-family="verdana" font-size="7pt" start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeUndergraduateTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="2" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Predoctoral:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Single Degree</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocSingleDegreeStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocSingleDegreeTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Dual Degree</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocDualDegreeStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocDualDegreeTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>Total Predoctoral</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocTotalStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePredocTotalTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="2" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Postdoctoral:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Non-Degree Seeking</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocNonDegreeStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocNonDegreeTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Degree Seeking</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocDegreeStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocDegreeTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="15" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="15" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="15" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>Total Postdoctoral</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="15" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocTotalStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="15" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativePostdocTotalTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="2" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Other:</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeOtherStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeOtherTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>Totals:&#160;&#160;&#160; </xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalStipendsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTuitionAndFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="2" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>Total Stipends + Tuition/Fees Requested&#160;&#160;&#160; </xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table font-family="verdana" font-size="7pt" table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalStipendsAndTuitionFeesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="5" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:block text-align="center">
																											<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																										</fo:block>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>B. Other Direct Costs</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" text-align="center" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>Funds</xsl:text>
																										</fo:inline>
																										<fo:block/>
																										<fo:inline font-size="7pt">
																											<xsl:text>Requested ($)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Trainee Travel</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTraineeTravelRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Training Related Expenses</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTrainingRelatedExpensesRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Total Direct Costs from R&amp;R Budget Form (if applicable)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeResearchDirectCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt">
																											<xsl:text>&#160;&#160;&#160; Consortium Training Costs (if applicable)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeConsortiumTrainingCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="3" padding="2pt" text-align="right" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>Total Other Direct Costs Requested&#160;&#160;&#160; </xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalOtherDirectCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="5" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:block text-align="center">
																											<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																										</fo:block>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>C. Total Direct Costs Requested (A + B)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalDirectCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="5" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:block text-align="center">
																											<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																										</fo:block>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="3" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>D. Total Indirect Costs Requested</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block/>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalIndirectCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="5" padding="2pt" display-align="center">
																									<fo:block>
																										<fo:block text-align="center">
																											<fo:leader leader-pattern="rule" rule-thickness="0.5pt" leader-length="100%"/>
																										</fo:block>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																							<fo:table-row>
																								<fo:table-cell font-family="Verdana" font-size="7pt" number-columns-spanned="4" padding="2pt" height="7" display-align="center">
																									<fo:block>
																										<fo:inline font-size="7pt" font-weight="bold">
																											<xsl:text>E. Total Direct and Indirect Costs Requested (C + D)</xsl:text>
																										</fo:inline>
																									</fo:block>
																								</fo:table-cell>
																								<fo:table-cell font-family="Verdana" font-size="7pt" padding="2pt" height="7" display-align="center">
																									<fo:block>
																										<fo:inline-container>
																											<fo:block>
																												<xsl:text>&#x2029;</xsl:text>
																											</fo:block>
																										</fo:inline-container>
																										<fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="-1pt">
																											<fo:table-column column-width="proportional-column-width(1)"/>
																											<fo:table-body start-indent="0pt">
																												<fo:table-row>
																													<fo:table-cell font-family="Verdana" font-size="7pt" border="solid 1pt gray" padding="0" display-align="center">
																														<fo:block>
																															<fo:inline font-size="7pt">
																																<xsl:text>&#160;</xsl:text>
																															</fo:inline>
																															<xsl:for-each select="PHS398_TrainingBudget_2_0:CumulativeTotalDirectAndIndirectCostsRequested">
																																<xsl:variable name="value-of-template">
																																	<xsl:apply-templates/>
																																</xsl:variable>
																																<xsl:choose>
																																	<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																																		<fo:block>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:block>
																																	</xsl:when>
																																	<xsl:otherwise>
																																		<fo:inline>
																																			<xsl:copy-of select="$value-of-template"/>
																																		</fo:inline>
																																	</xsl:otherwise>
																																</xsl:choose>
																															</xsl:for-each>
																														</fo:block>
																													</fo:table-cell>
																												</fo:table-row>
																											</fo:table-body>
																										</fo:table>
																									</fo:block>
																								</fo:table-cell>
																							</fo:table-row>
																						</fo:table-body>
																					</fo:table>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</fo:table-body>
																</fo:table>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</xsl:for-each>
											</xsl:for-each>
										</xsl:for-each>
									</xsl:for-each>
								</fo:table-body>
							</fo:table>
						</xsl:if>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
