/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine.result;

import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.engine.ResultEvent;

public class TimingResult
extends EventObject
implements ResultEvent {
    private static final long serialVersionUID = 5335636381355236617L;
    private static final DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH.mm.ss.SSS");
    private String type;
    private DateTime start;
    private DateTime end;
    private ExecutionEnvironment environment;
    private String description;
    private Map<String, ?> resultDetails;

    public TimingResult(String description, String type, Object source, ExecutionEnvironment environment, DateTime start, DateTime end) {
        super(source);
        this.type = type;
        this.environment = environment;
        this.start = start;
        this.end = end;
        this.description = description;
    }

    public TimingResult(String type, Object source, ExecutionEnvironment environment, DateTime start, DateTime end) {
        super(source);
        this.type = type;
        this.environment = environment;
        this.start = start;
        this.end = end;
    }

    public Long getElapsedTimeInMilliseconds() {
        return this.end.getMillis() - this.start.getMillis();
    }

    public ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(fmt.print((ReadableInstant)this.end));
        sb.append(" EventType: " + this.type);
        sb.append(" (Start = " + fmt.print((ReadableInstant)this.start));
        sb.append(", End = " + fmt.print((ReadableInstant)this.end));
        sb.append(",  Elapsed Time = " + this.getElapsedTimeInMilliseconds().toString());
        sb.append(" milliseconds.)");
        return sb.toString();
    }

    public Boolean getResult() {
        return null;
    }

    public DateTime getTimestamp() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, ?> getResultDetails() {
        if (this.resultDetails == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.resultDetails);
    }

    public String getDescription() {
        return this.description;
    }
}

