/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.shortUrl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.shortUrl.ShortUrlDao;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="shortUrlDao")
public class ShortUrlDaoImpl
implements ShortUrlDao {
    @Autowired
    @Qualifier(value="dataSource")
    private DataSource dataSource;

    @Override
    public String getDocId(String id, String table, String column) {
        String sql = "select document_number from " + table + " where " + column + " = ?";
        return this.runQuery(sql, id);
    }

    @Override
    public String getDocIdByVersionStatus(String id, String table, String column) {
        String docId = this.getPendingDocId(id, table, column);
        if (StringUtils.isEmpty((CharSequence)docId)) {
            return this.getActiveDocId(id, table, column);
        }
        return docId;
    }

    protected String getActiveDocId(String id, String table, String column) {
        String versionStatus = VersionStatus.ACTIVE.toString();
        return this.getDocIdForVersionStatus(id, table, column, versionStatus);
    }

    protected String getPendingDocId(String id, String table, String column) {
        String versionStatus = VersionStatus.PENDING.toString();
        return this.getDocIdForVersionStatus(id, table, column, versionStatus);
    }

    protected String getDocIdForVersionStatus(String id, String table, String column, String versionStatus) {
        String sql = "select document_number from " + table + " where " + table + "_sequence_status = '" + versionStatus + "' and " + column + " = ?";
        return this.runQuery(sql, id);
    }

    @Override
    public String getDocIdByVersionHistory(String id, String table, String column) {
        String docId = this.getPendingDocIdByVersionHistory(id, table, column);
        if (StringUtils.isEmpty((CharSequence)docId)) {
            return this.getActiveDocIdByVersionHistory(id, table, column);
        }
        return docId;
    }

    protected String getActiveDocIdByVersionHistory(String id, String table, String column) {
        String versionStatus = VersionStatus.ACTIVE.toString();
        return this.getDocIdByVersionHistoryForVersionStatus(id, table, column, versionStatus);
    }

    protected String getPendingDocIdByVersionHistory(String id, String table, String column) {
        String versionStatus = VersionStatus.PENDING.toString();
        return this.getDocIdByVersionHistoryForVersionStatus(id, table, column, versionStatus);
    }

    private String getDocIdByVersionHistoryForVersionStatus(String id, String table, String column, String versionStatus) {
        String sql = "select document_number from " + table + " t, version_history v where t." + column + " = v.seq_owner_version_name_value and t.sequence_number = v.seq_owner_seq_number and v.version_status = '" + versionStatus + "' and t." + column + " = ?";
        return this.runQuery(sql, id);
    }

    @Override
    public String getDocIdByMaxSequenceNumber(String id, String table, String column) {
        String sql = "select document_number from " + table + " where " + column + " = ? and sequence_number = (select max(sequence_number) from " + table + " where " + column + " = ?)";
        return this.runQuery(sql, id, id);
    }

    /*
     * Exception decompiling
     */
    private String runQuery(String sql, String ... ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setQueryParameters(PreparedStatement stmt, String[] ids) throws SQLException {
        for (int i = 0; i < ids.length; ++i) {
            stmt.setString(i + 1, ids[i]);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

