/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.contrib.jsptag;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.Tag;
import org.joda.time.contrib.jsptag.Resources;

public class Util {
    private static final String REQUEST = "request";
    private static final String SESSION = "session";
    private static final String APPLICATION = "application";
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    private static final Locale EMPTY_LOCALE = new Locale("", "");
    static final String REQUEST_CHAR_SET = "javax.servlet.jsp.jstl.fmt.request.charset";
    static Locale[] availableFormattingLocales;

    public static int getScope(String string) {
        int n = 1;
        if (REQUEST.equalsIgnoreCase(string)) {
            n = 2;
        } else if (SESSION.equalsIgnoreCase(string)) {
            n = 3;
        } else if (APPLICATION.equalsIgnoreCase(string)) {
            n = 4;
        }
        return n;
    }

    public static Enumeration getRequestLocales(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaders("accept-language");
        if (enumeration.hasMoreElements()) {
            return httpServletRequest.getLocales();
        }
        return enumeration;
    }

    public static Locale parseLocale(String string) {
        return Util.parseLocale(string, null);
    }

    public static Locale parseLocale(String string, String string2) {
        Locale locale = null;
        String string3 = string;
        String string4 = null;
        int n = -1;
        n = string.indexOf(45);
        if (n > -1 || (n = string.indexOf(95)) > -1) {
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        if (string3 == null || string3.length() == 0) {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_NO_LANGUAGE"));
        }
        if (string4 == null) {
            locale = string2 != null ? new Locale(string3, "", string2) : new Locale(string3, "");
        } else if (string4.length() > 0) {
            locale = string2 != null ? new Locale(string3, string4, string2) : new Locale(string3, string4);
        } else {
            throw new IllegalArgumentException(Resources.getMessage("LOCALE_EMPTY_COUNTRY"));
        }
        return locale;
    }

    static void setResponseLocale(PageContext pageContext, Locale locale) {
        ServletResponse servletResponse = pageContext.getResponse();
        servletResponse.setLocale(locale);
        if (pageContext.getSession() != null) {
            try {
                pageContext.setAttribute(REQUEST_CHAR_SET, (Object)servletResponse.getCharacterEncoding(), 3);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    static Locale getFormattingLocale(PageContext pageContext, Tag tag, boolean bl, Locale[] localeArray) {
        LocalizationContext localizationContext = null;
        localizationContext = Util.getLocalizationContext(pageContext);
        if (localizationContext != null && localizationContext.getLocale() != null) {
            if (bl) {
                Util.setResponseLocale(pageContext, localizationContext.getLocale());
            }
            return localizationContext.getLocale();
        }
        Locale locale = null;
        Locale locale2 = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        locale = locale2 != null ? Util.findFormattingMatch(locale2, localeArray) : Util.findFormattingMatch(pageContext, localeArray);
        if (locale == null && (locale2 = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            locale = Util.findFormattingMatch(locale2, localeArray);
        }
        if (bl && locale != null) {
            Util.setResponseLocale(pageContext, locale);
        }
        return locale;
    }

    static Locale getFormattingLocale(PageContext pageContext) {
        Locale locale = null;
        Locale locale2 = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        locale = locale2 != null ? Util.findFormattingMatch(locale2, availableFormattingLocales) : Util.findFormattingMatch(pageContext, availableFormattingLocales);
        if (locale == null && (locale2 = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null) {
            locale = Util.findFormattingMatch(locale2, availableFormattingLocales);
        }
        if (locale != null) {
            Util.setResponseLocale(pageContext, locale);
        }
        return locale;
    }

    static Locale getLocale(PageContext pageContext, String string) {
        Locale locale = null;
        Object object = Config.find((PageContext)pageContext, (String)string);
        if (object != null) {
            locale = object instanceof Locale ? (Locale)object : Util.parseLocale((String)object);
        }
        return locale;
    }

    private static Locale findFormattingMatch(PageContext pageContext, Locale[] localeArray) {
        Locale locale;
        Locale locale2 = null;
        Enumeration enumeration = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enumeration.hasMoreElements() && (locale2 = Util.findFormattingMatch(locale = (Locale)enumeration.nextElement(), localeArray)) == null) {
        }
        return locale2;
    }

    private static Locale findFormattingMatch(Locale locale, Locale[] localeArray) {
        Locale locale2 = null;
        boolean bl = false;
        for (int i = 0; i < localeArray.length; ++i) {
            if (locale.equals(localeArray[i])) {
                locale2 = localeArray[i];
                break;
            }
            if (!"".equals(locale.getVariant()) && "".equals(localeArray[i].getVariant()) && locale.getLanguage().equals(localeArray[i].getLanguage()) && locale.getCountry().equals(localeArray[i].getCountry())) {
                locale2 = localeArray[i];
                bl = true;
                continue;
            }
            if (bl || !locale.getLanguage().equals(localeArray[i].getLanguage()) || !"".equals(localeArray[i].getCountry()) || locale2 != null) continue;
            locale2 = localeArray[i];
        }
        return locale2;
    }

    public static LocalizationContext getLocalizationContext(PageContext pageContext) {
        LocalizationContext localizationContext = null;
        Object object = Config.find((PageContext)pageContext, (String)"javax.servlet.jsp.jstl.fmt.localizationContext");
        if (object == null) {
            return null;
        }
        localizationContext = object instanceof LocalizationContext ? (LocalizationContext)object : Util.getLocalizationContext(pageContext, (String)object);
        return localizationContext;
    }

    public static LocalizationContext getLocalizationContext(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        ResourceBundle resourceBundle = null;
        if (string == null || string.equals("")) {
            return new LocalizationContext();
        }
        Locale locale = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.locale");
        if (locale != null) {
            resourceBundle = Util.findMatch(string, locale);
            if (resourceBundle != null) {
                localizationContext = new LocalizationContext(resourceBundle, locale);
            }
        } else {
            localizationContext = Util.findMatch(pageContext, string);
        }
        if (localizationContext == null && (locale = Util.getLocale(pageContext, "javax.servlet.jsp.jstl.fmt.fallbackLocale")) != null && (resourceBundle = Util.findMatch(string, locale)) != null) {
            localizationContext = new LocalizationContext(resourceBundle, locale);
        }
        if (localizationContext == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string, EMPTY_LOCALE, Thread.currentThread().getContextClassLoader());
                if (resourceBundle != null) {
                    localizationContext = new LocalizationContext(resourceBundle, null);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (localizationContext != null) {
            if (localizationContext.getLocale() != null) {
                Util.setResponseLocale(pageContext, localizationContext.getLocale());
            }
        } else {
            localizationContext = new LocalizationContext();
        }
        return localizationContext;
    }

    private static LocalizationContext findMatch(PageContext pageContext, String string) {
        LocalizationContext localizationContext = null;
        Enumeration enumeration = Util.getRequestLocales((HttpServletRequest)pageContext.getRequest());
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            ResourceBundle resourceBundle = Util.findMatch(string, locale);
            if (resourceBundle == null) continue;
            localizationContext = new LocalizationContext(resourceBundle, locale);
            break;
        }
        return localizationContext;
    }

    private static ResourceBundle findMatch(String string, Locale locale) {
        ResourceBundle resourceBundle = null;
        try {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle(string, locale, Thread.currentThread().getContextClassLoader());
            Locale locale2 = resourceBundle2.getLocale();
            if (locale.equals(locale2)) {
                resourceBundle = resourceBundle2;
            } else if (locale.getLanguage().equals(locale2.getLanguage()) && ("".equals(locale2.getCountry()) || locale.getCountry().equals(locale2.getCountry()))) {
                resourceBundle = resourceBundle2;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return resourceBundle;
    }

    static {
        Locale[] localeArray = DateFormat.getAvailableLocales();
        Locale[] localeArray2 = NumberFormat.getAvailableLocales();
        Vector<Locale> vector = new Vector<Locale>(localeArray.length);
        block0: for (int i = 0; i < localeArray.length; ++i) {
            for (int j = 0; j < localeArray2.length; ++j) {
                if (!localeArray[i].equals(localeArray2[j])) continue;
                vector.add(localeArray[i]);
                continue block0;
            }
        }
        availableFormattingLocales = new Locale[vector.size()];
        availableFormattingLocales = vector.toArray(availableFormattingLocales);
    }
}

