/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.keyvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public class MapValuesFinder
implements KeyValuesFinder {
    private Map<String, String> keyValues;

    public MapValuesFinder(Map<String, String> keyValues) {
        this.setKeyValues(keyValues);
    }

    public void setKeyValues(Map<String, String> keyValues) {
        if (keyValues == null) {
            throw new IllegalArgumentException("keyValues was null");
        }
        this.keyValues = Collections.unmodifiableMap(new HashMap<String, String>(keyValues));
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<ConcreteKeyValue> list = new ArrayList<ConcreteKeyValue>();
        for (Map.Entry<String, String> entry : this.keyValues.entrySet()) {
            list.add(new ConcreteKeyValue(entry));
        }
        return Collections.unmodifiableList(list);
    }

    public List<KeyValue> getKeyValues(boolean includeActiveOnly) {
        return this.getKeyValues();
    }

    public Map<String, String> getKeyLabelMap() {
        return this.keyValues;
    }

    public String getKeyLabel(String key) {
        return this.keyValues.get(key);
    }

    public void clearInternalCache() {
    }
}

