/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.kew.api.document.InvalidDocumentContentException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StandardDocumentContent
implements DocumentContent,
Serializable {
    private static final long serialVersionUID = -3189330007364191220L;
    private static final String LEGACY_FLEXDOC_ELEMENT = "flexdoc";
    private String docContent;
    private transient Document document;
    private transient Element applicationContent;
    private transient Element attributeContent;
    private transient Element searchableContent;
    private RouteContext routeContext;

    public StandardDocumentContent(String docContent) {
        this(docContent, null);
    }

    public StandardDocumentContent(String docContent, RouteContext routeContext) {
        this.routeContext = routeContext;
        this.initialize(docContent, routeContext);
    }

    private void initialize(String docContent, RouteContext routeContext) {
        if (StringUtils.isEmpty((String)docContent)) {
            this.docContent = "";
            this.document = null;
        } else {
            try {
                this.docContent = docContent;
                this.document = this.parseDocContent(docContent);
                this.extractElements(this.document);
            }
            catch (IOException e) {
                throw new InvalidDocumentContentException("I/O Error when attempting to parse document content.", (Throwable)e);
            }
            catch (SAXException e) {
                throw new InvalidDocumentContentException("XML parse error when attempting to parse document content.", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new RiceRuntimeException("XML parser configuration error when attempting to parse document content.", (Throwable)e);
            }
        }
    }

    private Document parseDocContent(String docContent) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(new InputSource(new BufferedReader(new StringReader(docContent))));
    }

    private void extractElements(Document document) {
        if (!document.getDocumentElement().getNodeName().equals("documentContent")) {
            if (document.getDocumentElement().getNodeName().equals(LEGACY_FLEXDOC_ELEMENT)) {
                this.attributeContent = document.getDocumentElement();
            } else {
                this.applicationContent = document.getDocumentElement();
            }
        } else {
            NodeList nodes = document.getDocumentElement().getChildNodes();
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node node = nodes.item(index);
                if (node.getNodeType() == 1 && node.getNodeName().equals("applicationContent")) {
                    int numChildElements = 0;
                    for (int childIndex = 0; childIndex < node.getChildNodes().getLength(); ++childIndex) {
                        Node child = node.getChildNodes().item(childIndex);
                        if (child.getNodeType() != 1) continue;
                        this.applicationContent = (Element)child;
                        ++numChildElements;
                    }
                    if (numChildElements <= true) continue;
                    this.applicationContent = (Element)node;
                    continue;
                }
                if (node.getNodeType() == 1 && node.getNodeName().equals("attributeContent")) {
                    this.attributeContent = (Element)node;
                    continue;
                }
                if (node.getNodeType() != 1 || !node.getNodeName().equals("searchableContent")) continue;
                this.searchableContent = (Element)node;
            }
        }
    }

    @Override
    public Element getApplicationContent() {
        return this.applicationContent;
    }

    @Override
    public Element getAttributeContent() {
        return this.attributeContent;
    }

    @Override
    public String getDocContent() {
        return this.docContent;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public Element getSearchableContent() {
        return this.searchableContent;
    }

    @Override
    public RouteContext getRouteContext() {
        return this.routeContext;
    }

    private void readObject(ObjectInputStream ais) throws IOException, ClassNotFoundException {
        ais.defaultReadObject();
        this.initialize(this.docContent, this.routeContext);
    }
}

