--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2015 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

CREATE SEQUENCE SEQ_AWARD_REPORT_NOTIF_SENT_ID INCREMENT BY 1 START WITH 1 NOCACHE;

ALTER TABLE AWARD_REPORT_NOTIFICATION_SENT
ADD AWARD_REPORT_NOTIF_SENT_ID NUMBER(22);


DECLARE

  O_ID VARCHAR(36);
  NEXT_ID NUMBER(19);

  CURSOR CUR IS SELECT OBJ_ID FROM AWARD_REPORT_NOTIFICATION_SENT WHERE AWARD_REPORT_NOTIF_SENT_ID IS NULL;

BEGIN

  OPEN CUR;

  LOOP
    FETCH CUR INTO O_ID;
    EXIT WHEN CUR%NOTFOUND;

    SELECT SEQ_AWARD_REPORT_NOTIF_SENT_ID.NEXTVAL INTO NEXT_ID FROM DUAL;

    UPDATE AWARD_REPORT_NOTIFICATION_SENT SET AWARD_REPORT_NOTIF_SENT_ID = NEXT_ID WHERE OBJ_ID = O_ID;
  END LOOP;

  CLOSE CUR;
END;
/

ALTER TABLE AWARD_REPORT_NOTIFICATION_SENT
ADD CONSTRAINT PK_AWARD_REPORT_NOTIF_SENT
PRIMARY KEY (AWARD_REPORT_NOTIF_SENT_ID);


CREATE SEQUENCE SEQ_AWARD_REPORT_TRACKING_ID INCREMENT BY 1 START WITH 1 NOCACHE;

ALTER TABLE AWARD_REPORT_TRACKING
ADD AWARD_REPORT_TRACKING_ID NUMBER(22);

DECLARE

  O_ID VARCHAR(36);
  NEXT_ID NUMBER(19);

  CURSOR CUR IS SELECT OBJ_ID FROM AWARD_REPORT_TRACKING WHERE AWARD_REPORT_TRACKING_ID IS NULL;

BEGIN

  OPEN CUR;

  LOOP
    FETCH CUR INTO O_ID;
    EXIT WHEN CUR%NOTFOUND;

    SELECT SEQ_AWARD_REPORT_TRACKING_ID.NEXTVAL INTO NEXT_ID FROM DUAL;

    UPDATE AWARD_REPORT_TRACKING SET AWARD_REPORT_TRACKING_ID = NEXT_ID WHERE OBJ_ID = O_ID;
  END LOOP;

  CLOSE CUR;
END;
/

ALTER TABLE AWARD_REPORT_TRACKING
ADD CONSTRAINT PK_AWARD_REPORT_TRACKING
PRIMARY KEY (AWARD_REPORT_TRACKING_ID);


ALTER TABLE VERSION_HISTORY
ADD CONSTRAINT PK_VERSION_HISTORY
PRIMARY KEY (VERSION_HISTORY_ID);
