/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CatalogFactory {
    public static final String DELIMITER = ":";
    private static Map factories = new HashMap();
    static /* synthetic */ Class class$org$apache$commons$chain$CatalogFactory;

    public abstract Catalog getCatalog();

    public abstract void setCatalog(Catalog var1);

    public abstract Catalog getCatalog(String var1);

    public abstract void addCatalog(String var1, Catalog var2);

    public abstract Iterator getNames();

    public Command getCommand(String commandID) {
        int splitPos;
        String commandName = commandID;
        String catalogName = null;
        Catalog catalog = null;
        if (commandID != null && (splitPos = commandID.indexOf(DELIMITER)) != -1) {
            catalogName = commandID.substring(0, splitPos);
            commandName = commandID.substring(splitPos + DELIMITER.length());
            if (commandName.indexOf(DELIMITER) != -1) {
                throw new IllegalArgumentException("commandID [" + commandID + "] has too many delimiters (reserved for future use)");
            }
        }
        if (catalogName != null) {
            catalog = this.getCatalog(catalogName);
            if (catalog == null) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$chain$CatalogFactory == null ? (class$org$apache$commons$chain$CatalogFactory = CatalogFactory.class$("org.apache.commons.chain.CatalogFactory")) : class$org$apache$commons$chain$CatalogFactory));
                log.warn((Object)("No catalog found for name: " + catalogName + "."));
                return null;
            }
        } else {
            catalog = this.getCatalog();
            if (catalog == null) {
                Log log = LogFactory.getLog((Class)(class$org$apache$commons$chain$CatalogFactory == null ? (class$org$apache$commons$chain$CatalogFactory = CatalogFactory.class$("org.apache.commons.chain.CatalogFactory")) : class$org$apache$commons$chain$CatalogFactory));
                log.warn((Object)"No default catalog found.");
                return null;
            }
        }
        return catalog.getCommand(commandName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogFactory getInstance() {
        CatalogFactory factory = null;
        ClassLoader cl = CatalogFactory.getClassLoader();
        Map map = factories;
        synchronized (map) {
            factory = (CatalogFactory)factories.get(cl);
            if (factory == null) {
                factory = new CatalogFactoryBase();
                factories.put(cl, factory);
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map map = factories;
        synchronized (map) {
            factories.remove(CatalogFactory.getClassLoader());
        }
    }

    private static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$apache$commons$chain$CatalogFactory == null ? (class$org$apache$commons$chain$CatalogFactory = CatalogFactory.class$("org.apache.commons.chain.CatalogFactory")) : class$org$apache$commons$chain$CatalogFactory).getClassLoader();
        }
        return cl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

