/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.propdev.impl.s2s.map.ApplicantOrganization;
import org.kuali.coeus.propdev.impl.s2s.map.Attachments;
import org.kuali.coeus.propdev.impl.s2s.map.Compliance;
import org.kuali.coeus.propdev.impl.s2s.map.FundingOpportunity;
import org.kuali.coeus.propdev.impl.s2s.map.KeyPerson;
import org.kuali.coeus.propdev.impl.s2s.map.RenewalInformation;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"title", "projectDescription", "areasAffected", "deviationAuthorization", "suggestedReviewers", "reviewersNotToInclude", "startDate", "endDate", "awardNumber", "agencyName", "cfdaNumbers", "cfdaProgramTitle", "fundingOpportunity", "applicantOrganization", "projectDirector", "contactPerson", "compliance", "renewalInformation", "attachments"})
public class Project {
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The project title. Similar to the proposal title.")
    private String title;
    @JsonProperty(value="projectDescription")
    @JsonPropertyDescription(value="A more detailed description of the project. Comes from the \"Project Summary\" abstract type.")
    private String projectDescription;
    @JsonProperty(value="areasAffected")
    @JsonPropertyDescription(value="A short description of the areas affected by the project. Comes from the \"Areas Affected\" abstract type.")
    private String areasAffected;
    @JsonProperty(value="deviationAuthorization")
    @JsonPropertyDescription(value="Explanation of the reasoning for deviating from NSF application instructions (if applicable). Comes from the \"Deviation Authorizatio\" abstract type.")
    private String deviationAuthorization;
    @JsonProperty(value="suggestedReviewers")
    @JsonPropertyDescription(value="A list of suggested reviewers. Comes from the \"Suggested Reviewers\" abstract type.")
    private String suggestedReviewers;
    @JsonProperty(value="reviewersNotToInclude")
    @JsonPropertyDescription(value="A list of reviewers suggested to not be included. Comes from the \"Reviewers Not to Include\" abstract type.")
    private String reviewersNotToInclude;
    @JsonProperty(value="startDate")
    @JsonPropertyDescription(value="The date that work is proposed to begin on the project.")
    private Date startDate;
    @JsonProperty(value="endDate")
    @JsonPropertyDescription(value="The date that work is proposed to end on the project.")
    private Date endDate;
    @JsonProperty(value="awardNumber")
    @JsonPropertyDescription(value="Award associated with this project.")
    private String awardNumber;
    @JsonProperty(value="agencyName")
    @JsonPropertyDescription(value="The name of the agency to which the project is being submitted.")
    private String agencyName;
    @JsonProperty(value="cfdaNumbers")
    @JsonPropertyDescription(value="Catalog of Federal Domestic Assistance number(s) associated with this category of funding.")
    private List<String> cfdaNumbers = new ArrayList<String>();
    @JsonProperty(value="cfdaProgramTitle")
    @JsonPropertyDescription(value="Catalog of Federal Domestic Assistance title associated with this category of funding.")
    private String cfdaProgramTitle;
    @JsonProperty(value="fundingOpportunity")
    @JsonPropertyDescription(value="Information about the specific grant funds for which the applicant is applying")
    private FundingOpportunity fundingOpportunity;
    @JsonProperty(value="applicantOrganization")
    @JsonPropertyDescription(value="The applicant organization submitting a grant project")
    private ApplicantOrganization applicantOrganization;
    @JsonProperty(value="projectDirector")
    @JsonPropertyDescription(value="A Key Person representing participants on a project.")
    private KeyPerson projectDirector;
    @JsonProperty(value="contactPerson")
    @JsonPropertyDescription(value="A Key Person representing participants on a project.")
    private KeyPerson contactPerson;
    @JsonProperty(value="compliance")
    @JsonPropertyDescription(value="Information related to compliance assurances.")
    private Compliance compliance;
    @JsonProperty(value="renewalInformation")
    @JsonPropertyDescription(value="Information related to renewals.")
    private RenewalInformation renewalInformation;
    @JsonProperty(value="attachments")
    @JsonPropertyDescription(value="Attachments available for inclusion by type.")
    private Attachments attachments;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="projectDescription")
    public String getProjectDescription() {
        return this.projectDescription;
    }

    @JsonProperty(value="projectDescription")
    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    @JsonProperty(value="areasAffected")
    public String getAreasAffected() {
        return this.areasAffected;
    }

    @JsonProperty(value="areasAffected")
    public void setAreasAffected(String areasAffected) {
        this.areasAffected = areasAffected;
    }

    @JsonProperty(value="deviationAuthorization")
    public String getDeviationAuthorization() {
        return this.deviationAuthorization;
    }

    @JsonProperty(value="deviationAuthorization")
    public void setDeviationAuthorization(String deviationAuthorization) {
        this.deviationAuthorization = deviationAuthorization;
    }

    @JsonProperty(value="suggestedReviewers")
    public String getSuggestedReviewers() {
        return this.suggestedReviewers;
    }

    @JsonProperty(value="suggestedReviewers")
    public void setSuggestedReviewers(String suggestedReviewers) {
        this.suggestedReviewers = suggestedReviewers;
    }

    @JsonProperty(value="reviewersNotToInclude")
    public String getReviewersNotToInclude() {
        return this.reviewersNotToInclude;
    }

    @JsonProperty(value="reviewersNotToInclude")
    public void setReviewersNotToInclude(String reviewersNotToInclude) {
        this.reviewersNotToInclude = reviewersNotToInclude;
    }

    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public Date getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="awardNumber")
    public String getAwardNumber() {
        return this.awardNumber;
    }

    @JsonProperty(value="awardNumber")
    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    @JsonProperty(value="agencyName")
    public String getAgencyName() {
        return this.agencyName;
    }

    @JsonProperty(value="agencyName")
    public void setAgencyName(String agencyName) {
        this.agencyName = agencyName;
    }

    @JsonProperty(value="cfdaNumbers")
    public List<String> getCfdaNumbers() {
        return this.cfdaNumbers;
    }

    @JsonProperty(value="cfdaNumbers")
    public void setCfdaNumbers(List<String> cfdaNumbers) {
        this.cfdaNumbers = cfdaNumbers;
    }

    @JsonProperty(value="cfdaProgramTitle")
    public String getCfdaProgramTitle() {
        return this.cfdaProgramTitle;
    }

    @JsonProperty(value="cfdaProgramTitle")
    public void setCfdaProgramTitle(String cfdaProgramTitle) {
        this.cfdaProgramTitle = cfdaProgramTitle;
    }

    @JsonProperty(value="fundingOpportunity")
    public FundingOpportunity getFundingOpportunity() {
        return this.fundingOpportunity;
    }

    @JsonProperty(value="fundingOpportunity")
    public void setFundingOpportunity(FundingOpportunity fundingOpportunity) {
        this.fundingOpportunity = fundingOpportunity;
    }

    @JsonProperty(value="applicantOrganization")
    public ApplicantOrganization getApplicantOrganization() {
        return this.applicantOrganization;
    }

    @JsonProperty(value="applicantOrganization")
    public void setApplicantOrganization(ApplicantOrganization applicantOrganization) {
        this.applicantOrganization = applicantOrganization;
    }

    @JsonProperty(value="projectDirector")
    public KeyPerson getProjectDirector() {
        return this.projectDirector;
    }

    @JsonProperty(value="projectDirector")
    public void setProjectDirector(KeyPerson projectDirector) {
        this.projectDirector = projectDirector;
    }

    @JsonProperty(value="contactPerson")
    public KeyPerson getContactPerson() {
        return this.contactPerson;
    }

    @JsonProperty(value="contactPerson")
    public void setContactPerson(KeyPerson contactPerson) {
        this.contactPerson = contactPerson;
    }

    @JsonProperty(value="compliance")
    public Compliance getCompliance() {
        return this.compliance;
    }

    @JsonProperty(value="compliance")
    public void setCompliance(Compliance compliance) {
        this.compliance = compliance;
    }

    @JsonProperty(value="renewalInformation")
    public RenewalInformation getRenewalInformation() {
        return this.renewalInformation;
    }

    @JsonProperty(value="renewalInformation")
    public void setRenewalInformation(RenewalInformation renewalInformation) {
        this.renewalInformation = renewalInformation;
    }

    @JsonProperty(value="attachments")
    public Attachments getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="attachments")
    public void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Project.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("projectDescription");
        sb.append('=');
        sb.append(this.projectDescription == null ? "<null>" : this.projectDescription);
        sb.append(',');
        sb.append("areasAffected");
        sb.append('=');
        sb.append(this.areasAffected == null ? "<null>" : this.areasAffected);
        sb.append(',');
        sb.append("deviationAuthorization");
        sb.append('=');
        sb.append(this.deviationAuthorization == null ? "<null>" : this.deviationAuthorization);
        sb.append(',');
        sb.append("suggestedReviewers");
        sb.append('=');
        sb.append(this.suggestedReviewers == null ? "<null>" : this.suggestedReviewers);
        sb.append(',');
        sb.append("reviewersNotToInclude");
        sb.append('=');
        sb.append(this.reviewersNotToInclude == null ? "<null>" : this.reviewersNotToInclude);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("endDate");
        sb.append('=');
        sb.append(this.endDate == null ? "<null>" : this.endDate);
        sb.append(',');
        sb.append("awardNumber");
        sb.append('=');
        sb.append(this.awardNumber == null ? "<null>" : this.awardNumber);
        sb.append(',');
        sb.append("agencyName");
        sb.append('=');
        sb.append(this.agencyName == null ? "<null>" : this.agencyName);
        sb.append(',');
        sb.append("cfdaNumbers");
        sb.append('=');
        sb.append(this.cfdaNumbers == null ? "<null>" : this.cfdaNumbers);
        sb.append(',');
        sb.append("cfdaProgramTitle");
        sb.append('=');
        sb.append(this.cfdaProgramTitle == null ? "<null>" : this.cfdaProgramTitle);
        sb.append(',');
        sb.append("fundingOpportunity");
        sb.append('=');
        sb.append(this.fundingOpportunity == null ? "<null>" : this.fundingOpportunity);
        sb.append(',');
        sb.append("applicantOrganization");
        sb.append('=');
        sb.append(this.applicantOrganization == null ? "<null>" : this.applicantOrganization);
        sb.append(',');
        sb.append("projectDirector");
        sb.append('=');
        sb.append(this.projectDirector == null ? "<null>" : this.projectDirector);
        sb.append(',');
        sb.append("contactPerson");
        sb.append('=');
        sb.append(this.contactPerson == null ? "<null>" : this.contactPerson);
        sb.append(',');
        sb.append("compliance");
        sb.append('=');
        sb.append(this.compliance == null ? "<null>" : this.compliance);
        sb.append(',');
        sb.append("renewalInformation");
        sb.append('=');
        sb.append(this.renewalInformation == null ? "<null>" : this.renewalInformation);
        sb.append(',');
        sb.append("attachments");
        sb.append('=');
        sb.append(this.attachments == null ? "<null>" : this.attachments);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.attachments == null ? 0 : this.attachments.hashCode());
        result = result * 31 + (this.deviationAuthorization == null ? 0 : this.deviationAuthorization.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = result * 31 + (this.contactPerson == null ? 0 : this.contactPerson.hashCode());
        result = result * 31 + (this.awardNumber == null ? 0 : this.awardNumber.hashCode());
        result = result * 31 + (this.reviewersNotToInclude == null ? 0 : this.reviewersNotToInclude.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.projectDirector == null ? 0 : this.projectDirector.hashCode());
        result = result * 31 + (this.agencyName == null ? 0 : this.agencyName.hashCode());
        result = result * 31 + (this.fundingOpportunity == null ? 0 : this.fundingOpportunity.hashCode());
        result = result * 31 + (this.suggestedReviewers == null ? 0 : this.suggestedReviewers.hashCode());
        result = result * 31 + (this.cfdaNumbers == null ? 0 : this.cfdaNumbers.hashCode());
        result = result * 31 + (this.compliance == null ? 0 : this.compliance.hashCode());
        result = result * 31 + (this.projectDescription == null ? 0 : this.projectDescription.hashCode());
        result = result * 31 + (this.cfdaProgramTitle == null ? 0 : this.cfdaProgramTitle.hashCode());
        result = result * 31 + (this.applicantOrganization == null ? 0 : this.applicantOrganization.hashCode());
        result = result * 31 + (this.areasAffected == null ? 0 : this.areasAffected.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.renewalInformation == null ? 0 : this.renewalInformation.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Project)) {
            return false;
        }
        Project rhs = (Project)other;
        return (this.attachments == rhs.attachments || this.attachments != null && this.attachments.equals(rhs.attachments)) && (this.deviationAuthorization == rhs.deviationAuthorization || this.deviationAuthorization != null && this.deviationAuthorization.equals(rhs.deviationAuthorization)) && (this.endDate == rhs.endDate || this.endDate != null && this.endDate.equals(rhs.endDate)) && (this.contactPerson == rhs.contactPerson || this.contactPerson != null && this.contactPerson.equals(rhs.contactPerson)) && (this.awardNumber == rhs.awardNumber || this.awardNumber != null && this.awardNumber.equals(rhs.awardNumber)) && (this.reviewersNotToInclude == rhs.reviewersNotToInclude || this.reviewersNotToInclude != null && this.reviewersNotToInclude.equals(rhs.reviewersNotToInclude)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.projectDirector == rhs.projectDirector || this.projectDirector != null && this.projectDirector.equals(rhs.projectDirector)) && (this.agencyName == rhs.agencyName || this.agencyName != null && this.agencyName.equals(rhs.agencyName)) && (this.fundingOpportunity == rhs.fundingOpportunity || this.fundingOpportunity != null && this.fundingOpportunity.equals(rhs.fundingOpportunity)) && (this.suggestedReviewers == rhs.suggestedReviewers || this.suggestedReviewers != null && this.suggestedReviewers.equals(rhs.suggestedReviewers)) && (this.cfdaNumbers == rhs.cfdaNumbers || this.cfdaNumbers != null && this.cfdaNumbers.equals(rhs.cfdaNumbers)) && (this.compliance == rhs.compliance || this.compliance != null && this.compliance.equals(rhs.compliance)) && (this.projectDescription == rhs.projectDescription || this.projectDescription != null && this.projectDescription.equals(rhs.projectDescription)) && (this.cfdaProgramTitle == rhs.cfdaProgramTitle || this.cfdaProgramTitle != null && this.cfdaProgramTitle.equals(rhs.cfdaProgramTitle)) && (this.applicantOrganization == rhs.applicantOrganization || this.applicantOrganization != null && this.applicantOrganization.equals(rhs.applicantOrganization)) && (this.areasAffected == rhs.areasAffected || this.areasAffected != null && this.areasAffected.equals(rhs.areasAffected)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.renewalInformation == rhs.renewalInformation || this.renewalInformation != null && this.renewalInformation.equals(rhs.renewalInformation)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate));
    }
}

