/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.action;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.action.RolePokerQueue;
import org.kuali.rice.kew.impl.action.RolePokerQueueAsyncCapableImpl;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.ksb.api.messaging.AsyncCapableService;
import org.kuali.rice.ksb.api.messaging.AsyncWrappable;

public class RolePokerQueueImpl
implements RolePokerQueue,
AsyncWrappable<RolePokerQueue> {
    private AsyncCapableService asyncCapableService;

    public void reResolveQualifiedRole(String documentId, String roleName, String qualifiedRoleNameLabel) {
        if (StringUtils.isBlank((String)documentId)) {
            throw new RiceIllegalArgumentException("documentId is null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName is null or blank");
        }
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(documentId);
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        if (qualifiedRoleNameLabel == null) {
            KEWServiceLocator.getRoleService().reResolveRole(document, roleName);
        } else {
            KEWServiceLocator.getRoleService().reResolveQualifiedRole(document, roleName, qualifiedRoleNameLabel);
        }
    }

    public void reResolveRole(String documentId, String roleName) {
        this.reResolveQualifiedRole(documentId, roleName, null);
    }

    public RolePokerQueue wrap(QName qname, String applicationId) {
        return new RolePokerQueueAsyncCapableImpl(this.asyncCapableService, this, qname, applicationId);
    }

    public AsyncCapableService getAsyncCapableService() {
        return this.asyncCapableService;
    }

    public void setAsyncCapableService(AsyncCapableService asyncCapableService) {
        this.asyncCapableService = asyncCapableService;
    }
}

