/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document.search;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;

public class DocumentStatusValuesFinder
extends KeyValuesBase {
    private static final String CATEGORY_CODE_PREFIX = "category:";

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> statuses = new ArrayList<KeyValue>();
        this.addCategory(statuses, DocumentStatusCategory.PENDING);
        this.addCategory(statuses, DocumentStatusCategory.SUCCESSFUL);
        this.addCategory(statuses, DocumentStatusCategory.UNSUCCESSFUL);
        return statuses;
    }

    private void addCategory(List<KeyValue> statuses, DocumentStatusCategory category) {
        statuses.add((KeyValue)new ConcreteKeyValue(CATEGORY_CODE_PREFIX + category.getCode(), category.getLabel() + " Statuses"));
        EnumSet documentStatuses = DocumentStatus.getStatusesForCategory((DocumentStatusCategory)category);
        for (DocumentStatus documentStatus : documentStatuses) {
            statuses.add((KeyValue)new ConcreteKeyValue(documentStatus.getCode(), "- " + documentStatus.getLabel()));
        }
    }
}

