<?xml version="1.0" encoding="UTF-8"?>
<!--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->


<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 sp2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java">
	<xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
	<xsl:param name="SV_OutputFormat" select="'PDF'"/>
	<xsl:variable name="XML" select="/"/>
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
				<fo:region-body margin-top="0.65in" margin-bottom="0.65in"/>
				<fo:region-after extent="0.65in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<xsl:call-template name="footerall"/>
				<fo:flow flow-name="xsl-region-body">
					<fo:block>
						<xsl:for-each select="$XML">
							<fo:inline-container>
								<fo:block>
									<xsl:text>&#x2029;</xsl:text>
								</fo:block>
							</fo:inline-container>
							<fo:table font-family="Times New Roman" font-size="9pt" table-layout="fixed" width="100%" border-spacing="2pt">
								<fo:table-column column-width="proportional-column-width(1)"/>
								<fo:table-body start-indent="0pt">
									<fo:table-row>
										<fo:table-cell padding="2pt" text-align="center" display-align="center">
											<fo:block>
												<fo:inline font-family="Times New Roman" font-size="15pt" font-weight="bold">
													<xsl:text>Negotiation Activity Report</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0" display-align="center">
											<fo:block>
												<fo:inline-container>
													<fo:block>
														<xsl:text>&#x2029;</xsl:text>
													</fo:block>
												</fo:inline-container>
												<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
													<fo:table-column column-width="15%"/>
													<fo:table-column column-width="35%"/>
													<fo:table-column column-width="25%"/>
													<fo:table-column column-width="25%"/>
													<fo:table-body start-indent="0pt">
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																<xsl:for-each select="negotiations">
																  <xsl:for-each select="negotiationData">
																	<xsl:for-each select="proposalNumber">
																	<fo:inline font-weight="bold">
																		<xsl:text>Proposal No:</xsl:text>
																	</fo:inline>
																	</xsl:for-each>
																   </xsl:for-each>
																  </xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="proposalNumber">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>																	
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="proposalTypes">
																				<xsl:for-each select="proposalTypeDesc">
																					<fo:inline font-weight="bold">
																						<xsl:text>Proposal Type: </xsl:text>
																					</fo:inline>
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Negotiation Id:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="negotiationId">																				
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Sponsor:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="sponsor">
																				<xsl:for-each select="sponsorCode">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																				<xsl:for-each select="sponsorName">
																					<fo:inline>
																						<xsl:text> : </xsl:text>
																					</fo:inline>
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Title:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="title">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Lead Unit:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="leadUnit">
																				<xsl:for-each select="unitNumber">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																				<xsl:for-each select="unitName">
																					<fo:inline>
																						<xsl:text> : </xsl:text>
																					</fo:inline>
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Investigator: </xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="investigator">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-left="0" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Start Date:</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="startDate">
																				<fo:inline>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																					<xsl:text>/</xsl:text>
																					<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																				</fo:inline>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding-right="0" padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Doc File Address:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="docFileAddress">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" height="1" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Contract Admin:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="2" padding="2pt" height="1" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="contractAdmin">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell padding-left="0" padding="2pt" height="1" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Status:</xsl:text>
																	</fo:inline>
																	<fo:inline>
																		<xsl:text>&#160;</xsl:text>
																	</fo:inline>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="status">
																				<xsl:for-each select="statusDesc">
																					<xsl:variable name="value-of-template">
																						<xsl:apply-templates/>
																					</xsl:variable>
																					<xsl:choose>
																						<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																							<fo:block>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:block>
																						</xsl:when>
																						<xsl:otherwise>
																							<fo:inline>
																								<xsl:copy-of select="$value-of-template"/>
																							</fo:inline>
																						</xsl:otherwise>
																					</xsl:choose>
																				</xsl:for-each>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="2pt" display-align="center">
																<fo:block>
																	<fo:inline font-weight="bold">
																		<xsl:text>Negotiator:</xsl:text>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
															<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																<fo:block>
																	<xsl:for-each select="negotiations">
																		<xsl:for-each select="negotiationData">
																			<xsl:for-each select="negotiator">
																				<xsl:variable name="value-of-template">
																					<xsl:apply-templates/>
																				</xsl:variable>
																				<xsl:choose>
																					<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																						<fo:block>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:block>
																					</xsl:when>
																					<xsl:otherwise>
																						<fo:inline>
																							<xsl:copy-of select="$value-of-template"/>
																						</fo:inline>
																					</xsl:otherwise>
																				</xsl:choose>
																			</xsl:for-each>
																		</xsl:for-each>
																	</xsl:for-each>
																</fo:block>
															</fo:table-cell>
														</fo:table-row>
														<fo:table-row>
															<fo:table-cell padding="0" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block/>
															</fo:table-cell>
															<fo:table-cell padding="0" display-align="center">
																<fo:block/>
															</fo:table-cell>
														</fo:table-row>
													</fo:table-body>
												</fo:table>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="2pt" display-align="center">
											<fo:block>
												<xsl:for-each select="negotiations">
													<xsl:for-each select="negotiationData">
														<fo:inline-container>
															<fo:block>
																<xsl:text>&#x2029;</xsl:text>
															</fo:block>
														</fo:inline-container>
														<xsl:if test="activities">
															<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-column column-width="proportional-column-width(1)"/>
																<fo:table-body start-indent="0pt">
																	<xsl:for-each select="activities">
																		<fo:table-row>
																			<fo:table-cell number-columns-spanned="4" padding="2pt" display-align="center">
																				<fo:block>
																					<fo:block text-align="center">
																						<fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
																					</fo:block>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Activity Date: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="activityDate">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Create Date: </xsl:text>
																					</fo:inline>
																					<xsl:for-each select="createDate">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Follow-up Date: </xsl:text>
																					</fo:inline>
																					<xsl:for-each select="followupDate">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Activity Type: </xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="3" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="activity">
																						<xsl:for-each select="activityDesc">
																							<fo:inline-container>
																								<fo:block>
																									<xsl:text>&#x2029;</xsl:text>
																								</fo:block>
																							</fo:inline-container>
																							<fo:block white-space="pre" white-space-collapse="false" wrap-option="wrap" white-space-treatment="ignore-if-surrounding-linefeed" margin="0pt">
																								<fo:block>
																									<xsl:variable name="value-of-template">
																										<xsl:apply-templates/>
																									</xsl:variable>
																									<xsl:choose>
																										<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																											<fo:block>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:block>
																										</xsl:when>
																										<xsl:otherwise>
																											<fo:inline>
																												<xsl:copy-of select="$value-of-template"/>
																											</fo:inline>
																										</xsl:otherwise>
																									</xsl:choose>
																								</fo:block>
																							</fo:block>
																						</xsl:for-each>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Last Update:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="lastDate">
																						<fo:inline>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), '00')"/>
																							<xsl:text>/</xsl:text>
																							<xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), '0000')"/>
																						</fo:inline>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Updated By:</xsl:text>
																					</fo:inline>
																					<fo:inline>
																						<xsl:text>&#160;</xsl:text>
																					</fo:inline>
																					<xsl:for-each select="updatedBy">
																						<xsl:variable name="value-of-template">
																							<xsl:apply-templates/>
																						</xsl:variable>
																						<xsl:choose>
																							<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																								<fo:block>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:block>
																							</xsl:when>
																							<xsl:otherwise>
																								<fo:inline>
																									<xsl:copy-of select="$value-of-template"/>
																								</fo:inline>
																							</xsl:otherwise>
																						</xsl:choose>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block>
																					<fo:inline font-weight="bold">
																						<xsl:text>Description:</xsl:text>
																					</fo:inline>
																				</fo:block>
																			</fo:table-cell>
																			<fo:table-cell padding="2pt" display-align="center">
																				<fo:block/>
																			</fo:table-cell>
																			<fo:table-cell number-columns-spanned="2" padding="2pt" display-align="center">
																				<fo:block/>
																			</fo:table-cell>
																		</fo:table-row>
																		<fo:table-row>
																			<fo:table-cell padding-left="6pt" number-columns-spanned="4" padding="2pt" display-align="center">
																				<fo:block>
																					<xsl:for-each select="description">
																						<fo:inline-container>
																							<fo:block>
																								<xsl:text>&#x2029;</xsl:text>
																							</fo:block>
																						</fo:inline-container>
																						<fo:block white-space="pre" white-space-collapse="false" margin="0pt" wrap-option="wrap">
																							<fo:block>
																								<xsl:variable name="value-of-template">
																									<xsl:apply-templates/>
																								</xsl:variable>
																								<xsl:choose>
																									<xsl:when test="contains(string($value-of-template),'&#x2029;')">
																										<fo:block>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:block>
																									</xsl:when>
																									<xsl:otherwise>
																										<fo:inline>
																											<xsl:copy-of select="$value-of-template"/>
																										</fo:inline>
																									</xsl:otherwise>
																								</xsl:choose>
																							</fo:block>
																						</fo:block>
																					</xsl:for-each>
																				</fo:block>
																			</fo:table-cell>
																		</fo:table-row>
																	</xsl:for-each>
																</fo:table-body>
															</fo:table>
														</xsl:if>
													</xsl:for-each>
												</xsl:for-each>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</xsl:for-each>
					</fo:block>
					<fo:block id="SV_RefID_PageTotal"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	<xsl:template name="footerall">
		<fo:static-content flow-name="xsl-region-after">
			<fo:block>
				<xsl:for-each select="$XML">
					<fo:inline-container>
						<fo:block>
							<xsl:text>&#x2029;</xsl:text>
						</fo:block>
					</fo:inline-container>
					<fo:table table-layout="fixed" width="100%" border-spacing="2pt">
						<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-column column-width="150"/>
						<fo:table-body start-indent="0pt">
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0" number-columns-spanned="2" height="1" display-align="center">
									<fo:block/>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell font-size="8pt" padding="0" text-align="left" display-align="center">
									<fo:block>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:text>&#160;</xsl:text>
										</fo:inline>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new
        										('MMMM d, yyyy'), java:java.util.Date.new())"/>
										</fo:inline>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:text>&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding="0" text-align="right" display-align="center">
									<fo:block>
										<fo:inline font-family="Times New Roman" font-size="8pt">
											<xsl:text>Page: </xsl:text>
										</fo:inline>
										<fo:page-number font-family="Times New Roman" font-size="8pt"/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</xsl:for-each>
			</fo:block>
		</fo:static-content>
	</xsl:template>
	<xsl:template name="double-backslash">
		<xsl:param name="text"/>
		<xsl:param name="text-length"/>
		<xsl:variable name="text-after-bs" select="substring-after($text, '\')"/>
		<xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
		<xsl:choose>
			<xsl:when test="$text-after-bs-length = 0">
				<xsl:choose>
					<xsl:when test="substring($text, $text-length) = '\'">
						<xsl:value-of select="concat(substring($text,1,$text-length - 1), '\\')"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$text"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), '\\')"/>
				<xsl:call-template name="double-backslash">
					<xsl:with-param name="text" select="$text-after-bs"/>
					<xsl:with-param name="text-length" select="$text-after-bs-length"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
