--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2018 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

ALTER TABLE AWARD_TEMPLATE DROP CONSTRAINT FK_AWARD_TEMPLATE_SPONSOR;
ALTER TABLE PROPOSAL DROP CONSTRAINT FK_PROPOSAL_SPONSOR_CODE;
ALTER TABLE SPONSOR_FORMS DROP CONSTRAINT FK_SPONSOR_FORMS;
ALTER TABLE SPONSOR_HIERARCHY DROP CONSTRAINT FK_SPONSOR_HIERARCHY_KRA;
ALTER TABLE NEGOTIATION_UNASSOC_DETAIL DROP CONSTRAINT NEGOTIATION_UNASSOC_DETAIL_FK3;
ALTER TABLE NEGOTIATION_UNASSOC_DETAIL DROP CONSTRAINT NEGOTIATION_UNASSOC_DETAIL_FK4;
ALTER TABLE AWARD_TRANSFERRING_SPONSOR DROP CONSTRAINT FK2_AWARD_TRANSFERRING_SPONSOR;

ALTER TABLE AWARD MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE SPONSOR MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE NEGOTIATION_UNASSOC_DETAIL MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE NEGOTIATION_UNASSOC_DETAIL MODIFY PRIME_SPONSOR_CODE VARCHAR2(20);
ALTER TABLE AWARD MODIFY PRIME_SPONSOR_CODE VARCHAR2(20);
ALTER TABLE AWARD_REPORT_TRACKING MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE AWARD_TEMPLATE MODIFY PRIME_SPONSOR_CODE VARCHAR2(20);
ALTER TABLE AWARD_TRANSFERRING_SPONSOR MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE EPS_PROPOSAL MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE EPS_PROPOSAL MODIFY PRIME_SPONSOR_CODE VARCHAR2(20);
ALTER TABLE PERSON_FIN_INT_DISCLOSURE MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE PROPOSAL MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE PROPOSAL MODIFY PRIME_SPONSOR_CODE VARCHAR2(20);
ALTER TABLE PROPOSAL_LOG MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE ROLODEX MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE SPONSOR_FORMS MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE SPONSOR_HIERARCHY MODIFY SPONSOR_CODE VARCHAR2(20);
ALTER TABLE SPONSOR_HIERARCHY_MT MODIFY SPONSOR_CODE VARCHAR2(20);

ALTER TABLE AWARD_TRANSFERRING_SPONSOR
    ADD CONSTRAINT FK2_AWARD_TRANSFERRING_SPONSOR FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE AWARD_TEMPLATE
    ADD CONSTRAINT FK_AWARD_TEMPLATE_SPONSOR FOREIGN KEY (PRIME_SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT FK_PROPOSAL_SPONSOR_CODE FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE SPONSOR_FORMS
    ADD CONSTRAINT FK_SPONSOR_FORMS FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE);

ALTER TABLE SPONSOR_HIERARCHY
    ADD CONSTRAINT FK_SPONSOR_HIERARCHY_KRA FOREIGN KEY (SPONSOR_CODE)
    REFERENCES SPONSOR (SPONSOR_CODE)
ON DELETE CASCADE;

ALTER TABLE NEGOTIATION_UNASSOC_DETAIL
	ADD ( CONSTRAINT NEGOTIATION_UNASSOC_DETAIL_FK3
	FOREIGN KEY(SPONSOR_CODE)
	REFERENCES SPONSOR(SPONSOR_CODE)
	 );

ALTER TABLE NEGOTIATION_UNASSOC_DETAIL
	ADD ( CONSTRAINT NEGOTIATION_UNASSOC_DETAIL_FK4
	FOREIGN KEY(PRIME_SPONSOR_CODE)
	REFERENCES SPONSOR(SPONSOR_CODE)
	 );

