/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.fetch.schema;

import java.io.IOException;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.kuali.coeus.propdev.impl.s2s.fetch.util.FetchUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public class SchemaBasedGrantsGovResourceFetcher {
    private static final String META_GRANT_APPLICATION_FORM_URL = "https://apply07.grants.gov/apply/system/schemas/MetaGrantApplicationForm.xsd";
    private static final String META_GRANT_APPLICATION_URL = "https://apply07.grants.gov/apply/system/schemas/MetaGrantApplication.xsd";
    private static final Predicate<byte[]> CONTAINS_HTML_PAGE = f -> new String((byte[])f).contains("<!DOCTYPE html>");
    private static final Predicate<byte[]> IS_EMPTY = ArrayUtils::isEmpty;

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        String baseDir = FetchUtils.directoryArg(args);
        if (baseDir != null) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            SchemaBasedGrantsGovResourceFetcher.fetchFromSchema(dBuilder.parse(META_GRANT_APPLICATION_FORM_URL), baseDir + "/schema/active");
            SchemaBasedGrantsGovResourceFetcher.fetchFromSchema(dBuilder.parse(META_GRANT_APPLICATION_URL), baseDir + "/schema/active");
        }
    }

    private static void fetchFromSchema(Document schema, String dir) {
        NamedNodeMap map = schema.getDocumentElement().getAttributes();
        IntStream.range(0, map.getLength()).parallel().mapToObj(i -> map.item(i).getNodeValue()).filter(attr -> attr.startsWith("http://apply.grants.gov/forms/")).forEach(attr -> SchemaBasedGrantsGovResourceFetcher.fetchResources(dir, attr));
    }

    private static void fetchResources(String dir, String attr) {
        String pdfUrl = attr.replace("http://apply.grants.gov/forms/", "https://apply07.grants.gov/apply/forms/sample/") + ".pdf";
        FetchUtils.fetch(pdfUrl, pdfUrl.substring(pdfUrl.lastIndexOf(47) + 1), dir + "/pdf", SchemaBasedGrantsGovResourceFetcher.containsHtmlPage());
        String instrUrl = attr.replace("http://apply.grants.gov/forms/", "https://apply07.grants.gov/apply/forms/instructions/") + "-Instructions.pdf";
        FetchUtils.fetch(instrUrl, instrUrl.substring(instrUrl.lastIndexOf(47) + 1), dir + "/instructions", SchemaBasedGrantsGovResourceFetcher.containsHtmlPage());
        String schemaUrl = attr.replace("http://apply.grants.gov/forms/", "https://apply07.grants.gov/apply/forms/schemas/") + ".xsd";
        FetchUtils.fetch(schemaUrl, schemaUrl.substring(schemaUrl.lastIndexOf(47) + 1), dir + "/xsd", SchemaBasedGrantsGovResourceFetcher.emptyBytes());
        String nihXslUrl = attr.replace("http://apply.grants.gov/forms/", "https://grants.nih.gov/grants/ElectronicReceipt/files/") + ".xsl";
        FetchUtils.fetch(nihXslUrl, nihXslUrl.substring(nihXslUrl.lastIndexOf(47) + 1), dir + "/xsl", SchemaBasedGrantsGovResourceFetcher.containsHtmlPage());
        String xslUrl = attr.replace("http://apply.grants.gov/forms/", "https://apply07.grants.gov/apply/forms/fo/") + ".fo.xsl";
        FetchUtils.fetch(xslUrl, xslUrl.substring(xslUrl.lastIndexOf(47) + 1), dir + "/xsl", SchemaBasedGrantsGovResourceFetcher.containsHtmlPage());
    }

    private static Predicate<byte[]> containsHtmlPage() {
        return CONTAINS_HTML_PAGE;
    }

    private static Predicate<byte[]> emptyBytes() {
        return IS_EMPTY;
    }
}

