/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.pdf;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;

public class LogAndMarkPdf {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 1 || StringUtils.isEmpty((CharSequence)args[0])) {
            System.err.println("Please provide a path to a valid pdf file.");
            return;
        }
        File source = new File(args[0]);
        if (!source.exists() && !source.isFile()) {
            System.err.println("Please provide a path to a valid pdf file. Path: " + args[0]);
            return;
        }
        try (PDDocument pdfDocument = PDDocument.load((File)source);){
            PdfBoxUtils.logFields((PDDocument)pdfDocument);
            PdfBoxUtils.markFields((PDDocument)pdfDocument);
            pdfDocument.save(source.getParent() + File.separator + source.getName() + "-MARKED.pdf");
        }
    }
}

