/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.fetch.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public final class FetchUtils {
    private FetchUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static void fetch(String url, String fileName, String pathName, Predicate<byte[]> reject) {
        block12: {
            try {
                File file = new File(pathName, fileName);
                if (file.exists()) {
                    System.out.println("Already Exists: " + url + " in " + pathName + "/" + fileName);
                    break block12;
                }
                System.out.println("Fetching: " + url + " to " + pathName + "/" + fileName);
                RestTemplate restTemplate = new RestTemplate();
                restTemplate.setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

                    public void handleError(ClientHttpResponse response) {
                    }
                });
                ResponseEntity response = restTemplate.getForEntity(url, Resource.class, new Object[0]);
                if (response.getStatusCode().is2xxSuccessful()) {
                    byte[] data = ((Resource)response.getBody()).getInputStream().readAllBytes();
                    if (!reject.test(data)) {
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        if (!file.exists()) {
                            file.createNewFile();
                            try (FileOutputStream out = new FileOutputStream(file);){
                                out.write(data);
                                out.flush();
                                break block12;
                            }
                        }
                        System.out.println("Already Exists: " + url + " in " + pathName + "/" + fileName);
                        break block12;
                    }
                    System.out.println("Rejected: " + url + " in " + pathName + "/" + fileName);
                    break block12;
                }
                System.out.println("Not Found: " + url + " in " + pathName + "/" + fileName + " http status: " + response.getStatusCode());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String directoryArg(String[] args) {
        if (args == null || args.length < 1 || StringUtils.isEmpty((CharSequence)args[0])) {
            System.err.println("Please provide a path to save the resources to.");
            return null;
        }
        String baseDir = args[0];
        File source = new File(baseDir);
        if (!source.exists() && !source.isDirectory()) {
            System.err.println("Please provide a path to a valid directory. Path: " + baseDir);
            return null;
        }
        return baseDir;
    }
}

