<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="Include.jsp"%>

<html lang="en">
<head>
<title>Kuali Enterprise Notification - My Preferences</title>
<meta name="Author" content="John Fereira">
<link href="css/notification.css" rel="stylesheet" type="text/css" />
<script language="JavaScript" type="text/javascript">
function subscribe() {
   document.forms['UpdatePreference'].action = 'SubscribeToChannel.form';
   document.forms['UpdatePreference'].submit();
}

function unsubscribe() {
   document.forms['UpdatePreference'].action = 'UnsubscribeFromChannel.form';
   document.forms['UpdatePreference'].submit();
}
</script>
</head>
<body>

		<div style="padding: 5px">						
        <div class="title">Channel Subscriptions</div>
		
		<form name="UpdatePreference" action="#">
			<table  border="0" cellpadding="0" cellspacing="0"
				class="bord-all" width="60%">
				<tr>
					<td class="thnormal"><strong>Channel Name</strong></td>
					<td class="thnormal" width="20%">&nbsp;</td>
				</tr>
				<c:forEach var="channel" items="${channels}">
					<tr>
						<td class="thnormal"><c:out	value="${channel.name}" /></td>
						<td align="center" width="15%">
		                    <c:set var="chid"><c:out value="${channel.id}" /></c:set>
		                                                                
		                    <c:if test="${empty currentsubs[chid]}" >  
		                    <a href="<c:url value="SubscribeToChannel.form"><c:param name="channelid" value="${channel.id}"/></c:url>">
		                    <img src="images/buttonsmall_subscribe.gif" border="0" alt="Subscribe" /></a>                                                   
		                    </c:if>
		                    <c:if test="${not empty currentsubs[chid]}" > 
		                    <a href="<c:url value="UnsubscribeFromChannel.form"><c:param name="channelid" value="${channel.id}"/></c:url>">
		                    <img src="images/buttonsmall_unsubscribe.gif" border="0" alt="Unsubscribe" /></a>                                                   
		                    </c:if>
		                    </td>
					</tr>
				</c:forEach>
			</table>
		</form>        					
		</div>

</body>
</html>
