/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

var Kc = Kc || {};
Kc.Dashboard = Kc.Dashboard || {};
(function(namespace, $) {

    namespace.redirectToDashboard = function(dashboardMode, dashboardBase, allowedRegex) {
        if (dashboardMode) {
            var rlMatches = /^.*[?&]returnLocation=([^&]*|.*).*$/.exec(window.location.search);
            var returnLocation = rlMatches && decodeURIComponent(rlMatches[1]);
            var blMatches = /^.*[?&]backLocation=([^&]*|.*).*$/.exec(window.location.search);
            var backLocation = blMatches && decodeURIComponent(blMatches[1]);
            var allowedRegex = new RegExp(allowedRegex);

            if (returnLocation && allowedRegex.test(returnLocation)) {
                top.location = returnLocation;
            } else if (backLocation && allowedRegex.test(backLocation)) {
                top.location = backLocation;
            } else {
                top.location = dashboardBase ? (dashboardBase + "/dashboard") : (window.location.origin + "/dashboard");
            }
        }
    }

})(Kc.Dashboard, jQuery);
