<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp" %>
<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<kul:page headerTitle="Index Documents" docTitle="" transactionalDocument="false"
          htmlFormAction="indexDocuments" errorKey="indexableDocs*">

    <div class="display: flex; flex-direction: column;">
        <c:forEach var="i" begin="0" end="9" step="1">
            <div>
                <label for="indexableDocs[${i}].documentNumber">Document ${i+1}:</label>
                <html:text name="KualiForm" property="indexableDocs[${i}].documentNumber"
                           title="Document Number ${i+1}" styleId="indexableDocs[${i}].documentNumber"/>
                <kul:checkErrors keyMatch="indexableDocs[${i}].documentNumber"
                                 auditMatch="indexableDocs[${i}].documentNumber"/>
                <c:if test="${hasErrors}">
                    <kul:fieldShowErrorIcon/>
                </c:if>
            </div>
        </c:forEach>
    </div>


    <html:image src="${ConfigProperties.kr.externalizable.images.url}buttonsmall_reload.gif" styleClass="globalbuttons"
                property="methodToCall.reload" title="reload" alt="reload" onclick="excludeSubmitRestriction=true"/>
    <html:image src="${ConfigProperties.kr.externalizable.images.url}buttonsmall_close.gif" styleClass="globalbuttons"
                property="methodToCall.close" title="close" alt="close"/>

    <html:image src="${ConfigProperties.kr.externalizable.images.url}buttonsmall_submit.gif" styleClass="globalbuttons"
                property="methodToCall.index" title="merge" alt="Index"/>

</kul:page>
