<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<%@ include file="/WEB-INF/jsp/kraExconTldHeader.jsp"%>

<c:set var="exconProjectAttributes" value="${DataDictionary.ExconProject.attributes}" />
<c:set var="exconProjectPersonAttributes" value="${DataDictionary.ExconProjectPerson.attributes}" />
<c:set var="exconProjectEmailAttributes" value="${DataDictionary.ExconProjectEmailContent.attributes}" />

<c:set var="readOnly" value="${not KualiForm.editingMode['fullEntry']}" scope="request" />
<c:set var="action" value="exconProjectActions" />

<kul:tab tabTitle="Communication History By Project Person" defaultOpen="false">
	<div class="tab-container" align="center">

		<h3>
		<span class="subhead-left"><label for="exconProjectEmailBean.commHistoryProjectPersonId"><b>Recipient:</b>&nbsp;&nbsp;</label>
			<kul:htmlControlAttribute property="exconProjectEmailBean.commHistoryProjectPersonId" attributeEntry="${exconProjectAttributes.emailRecipient}" />
			<html:image property="methodToCall.refresh"
						src='${ConfigProperties.kra.externalizable.images.url}tinybutton-update.gif'
						alt="Update Communication History Person" onclick="" styleClass="tinybutton"/>
		</span>
		</h3>


		<table>
			<tr>
				<th>Communication Date</th>
				<th>Content</th>
				<th>Project Number</th>
			</tr>
			<c:forEach var="communication"
					   items="${KualiForm.exconProjectEmailBean.communicationHistory}"
					   varStatus="communicationRowStatus">
				<tr>
					<td><div><c:out value="${communication.communicationDateStr}"/></div></td>
					<td><div><c:out value="${communication.description}"/></div></td>
					<td><div><c:out value="${communication.projectPerson.projectNumber != KualiForm.document.exconProjectList[0].projectNumber ?
							communication.projectPerson.projectNumber : \"Current\"}"/></div></td>
				</tr>
			</c:forEach>
		</table>

	</div>

</kul:tab>
