<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="readOnly" value="false"  scope="request"/>
<c:set var="questionnaireAttributes" value="${DataDictionary.Questionnaire.attributes}" />

<div class="tab-container" align="center">
    <h3>
        <span class="subhead-left"> Questionnaire </span>
        <span class="subhead-right"> <kul:help businessObjectClassName="org.kuali.coeus.common.questionnaire.framework.core.Questionnaire" altText="help"/> </span>
    </h3>
    
    <table id="from-table" width="100%" cellpadding="0" cellspacing="0" class="datatable">
        <tr>
        <td colspan="2" class="tab-subhead" width="50%">
            <div class="tab-subhead-r">
                Original
            </div>
        </td>
        <td colspan="2" class="tab-subhead" width="50%">
            New Copy
        </td>
        </tr>
        <tr>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.name}" labelFor="document.oldMaintainableObject.businessObject.name"/>
            </th>
            <td class="grid" width="25.0%">
               <html:text property="document.oldMaintainableObject.businessObject.name" 
                           styleId="document.oldMaintainableObject.businessObject.name" title="${questionnaireAttributes.name.label}" readonly="true"/>
            </td>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.name}" labelFor="document.newMaintainableObject.businessObject.name"/>
            </th>
            <td class="grid" width="25.0%">
                <kul:htmlControlAttribute property="document.newMaintainableObject.businessObject.name"
                                          attributeEntry="${questionnaireAttributes.name}" />
            </td>
        </tr>
        <tr>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.description}" labelFor="document.oldMaintainableObject.businessObject.description"/>
            </th>
            <td class="grid" width="25.0%">
               <html:textarea property="document.oldMaintainableObject.businessObject.description" rows="5" cols="40" title="${questionnaireAttributes.description.label}"
                           styleId="document.oldMaintainableObject.businessObject.description" readonly="true"/>
            </td>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.description}" labelFor="document.newMaintainableObject.businessObject.description"/>
            </th>
            <td class="grid" width="25.0%">
                <kul:htmlControlAttribute property="document.newMaintainableObject.businessObject.description" 
                                          attributeEntry="${questionnaireAttributes.description}" />
            </td>
        </tr>
        <tr>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.active}" labelFor="document.oldMaintainableObject.businessObject.active"/>
            </th>
            <td class="grid" width="25.0%">
               <html:checkbox property="document.oldMaintainableObject.businessObject.active" 
                           styleId="document.oldMaintainableObject.businessObject.active" disabled="true" title="${questionnaireAttributes.active.label}"/>
                           <label for="document.oldMaintainableObject.businessObject.active"><bean:write name="KualiForm" property="document.oldMaintainableObject.businessObject.active"/></label>
            </td>
            <th class="grid" width="25.0%" align="right">
                <kul:htmlAttributeLabel attributeEntry="${questionnaireAttributes.active}" labelFor="document.newMaintainableObject.businessObject.active"/>
            </th>
            <td class="grid" width="25.0%">
                <kul:htmlControlAttribute property="document.newMaintainableObject.businessObject.active" 
                                          attributeEntry="${questionnaireAttributes.active}" />
            </td>
        </tr>
    </table>
    
    <input type="hidden" id="document.oldMaintainableObject.businessObject.id" name="document.oldMaintainableObject.businessObject.id" value = "${KualiForm.document.oldMaintainableObject.businessObject.id}"/>
</div>
