/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
$j = jQuery.noConflict();

var optionLists=new Map();

function checkDynamicSelectValue (e, propertyObjName, searchMethod, ajaxURL) {
    var controlObj = document.getElementById(propertyObjName+"_display");
    var partialName=controlObj.value;
    if (partialName != null && partialName.length==3 && ((e.keyCode > 64 && e.keyCode < 91) || (e.keyCode > 96 && e.keyCode < 123) || e.keyCode==188 || e.keyCode==32)) {
        populateDynamicSelect(partialName, propertyObjName, searchMethod, ajaxURL);
    }
}

function checkValueAgainstOptions(displayObj, propertyObjName) {
    if (optionLists.has(propertyObjName)) {
        var valuesForSelect=optionLists.get(propertyObjName);
        if (valuesForSelect != undefined && valuesForSelect.length > 0) {
            for (var i = 0; i < valuesForSelect.length; i++) {
                var item = valuesForSelect[i];
                if (item.label == displayObj.value) {
                    var propertyObj=document.getElementById(propertyObjName);
                    propertyObj.value=item.value;
                    break;
                }
            }
        }
    }
}

function setupDynamicSelect (propertyObjName, searchMethod, ajaxURL) {
    jQuery(document).on('keyup', '[id="'+propertyObjName+'_display"]',
        function(e) {checkDynamicSelectValue(e, propertyObjName, searchMethod, ajaxURL);});
    var propertyObj=document.getElementById(propertyObjName);
    propertyObj.style.display="none";
    populateDynamicSelect(null,propertyObjName, searchMethod, ajaxURL);
}

function getDynamicSelectKey (selectedId, searchMethod, ajaxURL) {
    searchKey='';
    $j.ajax( {
        url : ajaxURL,
        type : 'POST',
        dataType : 'html',
        data : 'methodToCall=' + searchMethod + 'Key&code=' + selectedId + '&csrfToken=' + $j('[name=csrfToken]').val(),
        cache : false,
        async : false,
        timeout : 60000,
        error : function(jqXHR, textStatus, errorThrown){
            console.log(textStatus+':'+errorThrown);
        },

        success : function(data) {
            retVal = eval('(' + $j(data).find('#ret_value').html() + ')');
            searchKey=retVal.searchKey;
        }}

    );
    return searchKey;
}

function populateDynamicSelect (partialName, propertyObjName, searchMethod, ajaxURL) {
    var datalistObj = document.getElementById(propertyObjName+"_datalist");
    if (datalistObj==null || datalistObj.length<1) {return;}
    var propertyObj=document.getElementById(propertyObjName);
    var selectedId=propertyObj.value;
    if (ajaxURL==null || ajaxURL.length<1) {ajaxURL='exconIntlShipmentAjax.do';}
    if (partialName==null && selectedId!=null && selectedId.length>0) {
        partialName=getDynamicSelectKey(selectedId, searchMethod, ajaxURL);
    }

    if (partialName == null || partialName.length<1) {return;}

    $j.ajax( {
        url : ajaxURL,
        type : 'POST',
        dataType : 'html',
        data : 'methodToCall=' + searchMethod + '&code=' + partialName + '&csrfToken=' + $j('[name=csrfToken]').val(),
        cache : false,
        async : false,
        timeout : 60000,
        error : function(jqXHR, textStatus, errorThrown){
            console.log(textStatus+':'+errorThrown);
        },

        success : function(data) {
            valuesForSelect = eval('(' + $j(data).find('#ret_value').html() + ')');
            datalistObj.innerHTML='';
            if (valuesForSelect != undefined && valuesForSelect.length > 0) {
                var options = '';
                for (var i = 0; i < valuesForSelect.length; i++) {
                    var item = valuesForSelect[i];
                    options += "<option value='" + item.label + "'";
                    if (item.value == selectedId || valuesForSelect.length==1) {
                        options += " selected";
                        var displayObj=document.getElementById(propertyObjName+"_display");
                        displayObj.value=item.label;
                    }
                    options += "/>";
                }

                datalistObj.innerHTML=options;
                optionLists.set(propertyObjName,valuesForSelect);
            }
        }}

    );

}



