/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listeners;

import org.kuali.common.jdbc.listeners.NoOpSqlListener;
import org.kuali.common.jdbc.model.event.SqlEvent;
import org.kuali.common.jdbc.model.event.SqlExecutionEvent;
import org.kuali.common.util.Assert;
import org.kuali.common.util.inform.PercentCompleteInformer;

public final class ThreadSafeListener
extends NoOpSqlListener {
    private final PercentCompleteInformer informer;
    private final boolean trackProgressByUpdateCount;
    private volatile long aggregateTime;
    private volatile long aggregateUpdateCount;
    private volatile long aggregateSqlCount;
    private volatile long aggregateSqlSize;

    public ThreadSafeListener(PercentCompleteInformer informer, boolean trackProgressByUpdateCount) {
        Assert.noNulls((Object[])new Object[]{informer});
        this.informer = informer;
        this.trackProgressByUpdateCount = trackProgressByUpdateCount;
    }

    @Override
    public synchronized void afterExecution(SqlExecutionEvent event) {
        this.aggregateTime += event.getStopTimeMillis() - event.getStartTimeMillis();
    }

    @Override
    public synchronized void afterExecuteSql(SqlEvent event) {
        this.aggregateUpdateCount += (long)event.getUpdateCount();
        ++this.aggregateSqlCount;
        this.aggregateSqlSize += (long)event.getSql().length();
        if (this.trackProgressByUpdateCount) {
            this.informer.incrementProgress((long)event.getUpdateCount());
        } else {
            this.informer.incrementProgress();
        }
    }

    public long getAggregateTime() {
        return this.aggregateTime;
    }

    public long getAggregateUpdateCount() {
        return this.aggregateUpdateCount;
    }

    public PercentCompleteInformer getInformer() {
        return this.informer;
    }

    public boolean isTrackProgressByUpdateCount() {
        return this.trackProgressByUpdateCount;
    }

    public long getAggregateSqlCount() {
        return this.aggregateSqlCount;
    }

    public long getAggregateSqlSize() {
        return this.aggregateSqlSize;
    }
}

