/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.model.context;

import java.util.Properties;
import org.kuali.common.jdbc.model.Credentials;
import org.kuali.common.util.Assert;
import org.kuali.common.util.PropertyUtils;

public final class ConnectionContext {
    private static final Properties DEFAULT_PROPERTIES = PropertyUtils.EMPTY;
    private final String url;
    private final Credentials credentials;
    private final Properties properties;

    public ConnectionContext(String url) {
        this(url, "NONE");
    }

    public ConnectionContext(String url, String username) {
        this(url, username, "NONE");
    }

    public ConnectionContext(String url, String username, String password) {
        this(url, new Credentials(username, password), DEFAULT_PROPERTIES);
    }

    public ConnectionContext(String url, Credentials credentials, Properties properties) {
        Assert.noNulls((Object[])new Object[]{credentials, properties});
        Assert.noBlanks((String[])new String[]{url});
        this.url = url;
        this.credentials = credentials;
        this.properties = PropertyUtils.toImmutable((Properties)properties);
    }

    public String getUrl() {
        return this.url;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

