/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.service;

import org.kuali.common.jdbc.model.ExecutionResult;
import org.kuali.common.jdbc.model.context.JdbcContext;
import org.kuali.common.jdbc.service.JdbcService;
import org.kuali.common.util.Assert;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JdbcExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(JdbcExecutable.class);
    public static final boolean DEFAULT_SKIP = false;
    private final JdbcService service;
    private final JdbcContext context;
    private final boolean skip;

    public JdbcExecutable(JdbcService service, JdbcContext context) {
        this(service, context, false);
    }

    public JdbcExecutable(JdbcService service, JdbcContext context, boolean skip) {
        Assert.noNulls((Object[])new Object[]{service, context});
        this.service = service;
        this.context = context;
        this.skip = skip;
    }

    public void execute() {
        if (this.skip) {
            return;
        }
        ExecutionResult result = this.service.executeSql(this.context);
        if (result.getStatementsExecuted() > 0L) {
            this.showResult(result);
        }
    }

    protected void showResult(ExecutionResult result) {
        String updates = FormatUtils.getCount((long)result.getUpdateCount());
        String statements = FormatUtils.getCount((long)result.getStatementsExecuted());
        String elapsed = FormatUtils.getTime((long)result.getElapsed());
        Object[] args = new Object[]{updates, statements, elapsed};
        logger.info("Rows updated: {}  SQL Statements: {}  Total time: {}", args);
    }

    public JdbcService getService() {
        return this.service;
    }

    public JdbcContext getContext() {
        return this.context;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

