/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.service.spring;

import java.sql.Driver;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.model.Credentials;
import org.kuali.common.jdbc.model.context.ConnectionContext;
import org.kuali.common.jdbc.model.context.DatabaseProcessContext;
import org.kuali.common.jdbc.service.spring.DatabaseProcessContextConfig;
import org.kuali.common.util.Assert;
import org.kuali.common.util.property.ImmutableProperties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

@Configuration
@Import(value={DatabaseProcessContextConfig.class})
public class DataSourceConfig {
    private static final String USERNAME_KEY = "user";
    private static final String PASSWORD_KEY = "password";
    @Autowired
    DatabaseProcessContext context;

    @Bean
    public DataSource dataSource() {
        ConnectionContext normal = this.context.getConnections().getNormal();
        return this.getDataSource(normal, this.jdbcDriver());
    }

    @Bean
    public DataSource dbaDataSource() {
        ConnectionContext dba = this.context.getConnections().getDba();
        return this.getDataSource(dba, this.jdbcDriver());
    }

    @Bean
    public Class<? extends Driver> jdbcDriverClass() {
        return this.context.getConnections().getDriver();
    }

    @Bean
    public Driver jdbcDriver() {
        return (Driver)BeanUtils.instantiateClass(this.jdbcDriverClass());
    }

    protected DataSource getDataSource(ConnectionContext context, Driver driver) {
        Properties properties = this.getProperties(context);
        return new SimpleDriverDataSource(driver, context.getUrl(), properties);
    }

    protected Properties getProperties(ConnectionContext context) {
        Credentials creds = context.getCredentials();
        String username = this.toNull(creds.getUsername(), "NONE");
        String password = this.toNull(creds.getPassword(), "NONE");
        Properties properties = new Properties(context.getProperties());
        if (username != null) {
            properties.setProperty(USERNAME_KEY, username);
        }
        if (password != null) {
            properties.setProperty(PASSWORD_KEY, password);
        }
        return new ImmutableProperties(properties);
    }

    protected String toNull(String token, String nullToken) {
        Assert.notNull((Object)nullToken);
        return StringUtils.equals((CharSequence)token, (CharSequence)nullToken) ? null : token;
    }
}

