/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.show;

import javax.sql.DataSource;
import org.kuali.common.jdbc.model.context.DatabaseProcessContext;
import org.kuali.common.jdbc.service.JdbcService;
import org.kuali.common.jdbc.show.ShowUtils;
import org.kuali.common.util.Assert;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShowDbaConfigExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ShowDbaConfigExecutable.class);
    public static final boolean DEFAULT_SKIP = false;
    private final DatabaseProcessContext context;
    private final DataSource dataSource;
    private final JdbcService service;
    private final boolean skip;

    public ShowDbaConfigExecutable(DatabaseProcessContext context, DataSource dataSource, JdbcService service) {
        this(context, dataSource, service, false);
    }

    public ShowDbaConfigExecutable(DatabaseProcessContext context, DataSource dataSource, JdbcService service, boolean skip) {
        Assert.noNulls((Object[])new Object[]{context, dataSource, service});
        this.context = context;
        this.dataSource = dataSource;
        this.service = service;
        this.skip = skip;
    }

    public void execute() {
        if (this.skip) {
            return;
        }
        ShowUtils.showOpen(logger, this.context);
        ShowUtils.showDba(logger, this.context.getConnections().getDba());
        ShowUtils.showClose(logger, this.context, this.service, this.dataSource);
    }

    public DatabaseProcessContext getContext() {
        return this.context;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JdbcService getService() {
        return this.service;
    }

    public boolean isSkip() {
        return this.skip;
    }
}

