/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.show;

import javax.sql.DataSource;
import org.kuali.common.jdbc.model.Credentials;
import org.kuali.common.jdbc.model.context.ConnectionContext;
import org.kuali.common.jdbc.model.context.DatabaseProcessContext;
import org.kuali.common.jdbc.model.meta.Driver;
import org.kuali.common.jdbc.model.meta.JdbcMetaData;
import org.kuali.common.jdbc.model.meta.Product;
import org.kuali.common.jdbc.service.JdbcService;
import org.kuali.common.util.log.LoggerUtils;
import org.slf4j.Logger;

public class ShowUtils {
    public static void showOpen(Logger logger, DatabaseProcessContext context) {
        Credentials auth = context.getConnections().getNormal().getCredentials();
        String url = context.getConnections().getNormal().getUrl();
        logger.info("------------------------------------------------------------------------");
        logger.info("JDBC Configuration");
        logger.info("------------------------------------------------------------------------");
        logger.info("Vendor - {}", (Object)context.getVendor());
        logger.info("URL - {}", (Object)url);
        logger.info("Schema - {}", (Object)context.getSchema());
        logger.info("User - {}", (Object)LoggerUtils.getUsername((String)auth.getUsername()));
        logger.info("Password - {}", (Object)LoggerUtils.getPassword((String)auth.getUsername(), (String)auth.getPassword()));
    }

    public static void showDba(Logger logger, ConnectionContext dba) {
        Credentials auth = dba.getCredentials();
        logger.info("DBA URL - {}", (Object)dba.getUrl());
        logger.info("DBA User - {}", (Object)LoggerUtils.getUsername((String)auth.getUsername()));
        logger.info("DBA Password - {}", (Object)LoggerUtils.getPassword((String)auth.getUsername(), (String)auth.getPassword()));
    }

    public static void showClose(Logger logger, DatabaseProcessContext context, JdbcService service, DataSource dataSource) {
        logger.info("Driver - {}", (Object)context.getConnections().getDriver().getName());
        logger.info("SQL Encoding - {}", (Object)context.getEncoding());
        JdbcMetaData metadata = service.getJdbcMetaData(dataSource);
        Product product = metadata.getProduct();
        Driver driver = metadata.getDriver();
        logger.info("Product Name - {}", (Object)product.getName());
        logger.info("Product Version - {}", (Object)product.getVersion());
        logger.info("Driver Name - {}", (Object)driver.getName());
        logger.info("Driver Version - {}", (Object)driver.getVersion());
        logger.info("------------------------------------------------------------------------");
    }
}

