/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.sql.model;

import org.kuali.common.jdbc.model.Credentials;
import org.kuali.common.jdbc.sql.model.AdminSql;
import org.kuali.common.jdbc.sql.model.DbaSql;
import org.kuali.common.util.Assert;

public final class SqlContext {
    public static final int DEFAULT_THREADS = 8;
    private final DbaSql dba;
    private final AdminSql admin;
    private final Credentials credentials;
    private final String schema;
    private final String encoding;
    private final int threads;

    public SqlContext(Credentials credentials, DbaSql dbaSql, AdminSql adminSql, String schema, String encoding, int threads) {
        Assert.noNulls((Object[])new Object[]{credentials, dbaSql, adminSql});
        Assert.noBlanks((String[])new String[]{schema, encoding});
        Assert.isTrue((threads > 0 ? 1 : 0) != 0, (String)"threads must be a positive integer");
        this.dba = dbaSql;
        this.admin = adminSql;
        this.credentials = credentials;
        this.schema = schema;
        this.encoding = encoding;
        this.threads = threads;
    }

    public DbaSql getDba() {
        return this.dba;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getThreads() {
        return this.threads;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public AdminSql getAdmin() {
        return this.admin;
    }
}

