/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.sql.spring;

import javax.sql.DataSource;
import org.kuali.common.jdbc.listeners.LogSqlListener;
import org.kuali.common.jdbc.model.LogSqlMode;
import org.kuali.common.jdbc.model.context.JdbcContext;
import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.jdbc.reader.spring.SqlReaderConfig;
import org.kuali.common.jdbc.service.spring.DataSourceConfig;
import org.kuali.common.jdbc.sql.model.SqlContext;
import org.kuali.common.jdbc.sql.spring.SqlContextConfig;
import org.kuali.common.jdbc.suppliers.ComplexStringSupplier;
import org.kuali.common.util.log.LoggerLevel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DataSourceConfig.class, SqlContextConfig.class, SqlReaderConfig.class})
public class DbaContextConfig {
    private static final String BEFORE = "[dba:before]";
    private static final String AFTER = "[dba:after]";
    @Autowired
    SqlContext context;
    @Autowired
    SqlReader reader;
    @Autowired
    DataSourceConfig dataSourceConfig;

    public JdbcContext dbaBeforeContext() {
        return this.getContext(BEFORE, this.context.getDba().getBefore());
    }

    public JdbcContext dbaAfterContext() {
        return this.getContext(AFTER, this.context.getDba().getAfter());
    }

    protected JdbcContext getContext(String message, String sql) {
        DataSource dataSource = this.dataSourceConfig.dbaDataSource();
        ComplexStringSupplier supplier = new ComplexStringSupplier(sql, this.reader);
        LogSqlListener listener = new LogSqlListener(LoggerLevel.INFO, LogSqlMode.BEFORE);
        return new JdbcContext.Builder(dataSource, supplier).message(message).listener(listener).build();
    }
}

