/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import org.kuali.common.jdbc.reader.SqlReader;
import org.kuali.common.util.Assert;

public final class SqlLocationContext {
    public static final int DEFAULT_MAX_COUNT = 50;
    public static final int DEFAULT_MAX_SIZE = 51200;
    private final String encoding;
    private final SqlReader reader;
    private final int maxCount;
    private final int maxSize;

    public SqlLocationContext(String encoding, SqlReader reader) {
        this(encoding, reader, 50, 51200);
    }

    public SqlLocationContext(String encoding, SqlReader reader, int maxCount, int maxSize) {
        Assert.noBlanks((String[])new String[]{encoding});
        Assert.noNulls((Object[])new Object[]{reader});
        Assert.isTrue((maxCount > 0 ? 1 : 0) != 0, (String)"max count must be a positive integer");
        Assert.isTrue((maxSize >= 0 ? 1 : 0) != 0, (String)"max size is negative");
        this.encoding = encoding;
        this.reader = reader;
        this.maxCount = maxCount;
        this.maxSize = maxSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public SqlReader getReader() {
        return this.reader;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

