/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.suppliers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.kuali.common.jdbc.service.MetaDataUtils;
import org.kuali.common.jdbc.sql.model.SqlMetaData;
import org.kuali.common.jdbc.suppliers.AbstractSupplier;
import org.kuali.common.jdbc.suppliers.SqlLocationContext;
import org.kuali.common.jdbc.suppliers.SqlSupplier;
import org.kuali.common.util.Assert;
import org.kuali.common.util.LocationUtils;

public final class SqlLocationSupplier
extends AbstractSupplier
implements SqlSupplier {
    private final SqlLocationContext context;
    private final String location;
    private SqlMetaData metaData;
    private boolean open = false;
    private boolean done = false;
    private BufferedReader in;

    public SqlLocationSupplier(String location, SqlLocationContext context) {
        Assert.noNulls((Object[])new Object[]{context});
        Assert.noBlanks((String[])new String[]{location});
        Assert.exists((String)location);
        this.location = location;
        this.context = context;
    }

    @Override
    public synchronized void open() throws IOException {
        Assert.isFalse((boolean)this.open, (String)"Already open");
        this.open = true;
        this.done = false;
        this.in = LocationUtils.getBufferedReader((String)this.location, (String)this.context.getEncoding());
    }

    @Override
    public synchronized List<String> getSql() throws IOException {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        if (this.done) {
            return null;
        }
        List<String> sql = this.getSqlList();
        if (sql.size() == 0) {
            this.done = true;
            return null;
        }
        return sql;
    }

    @Override
    public synchronized void close() {
        Assert.isTrue((boolean)this.open, (String)"Not open");
        this.open = false;
        IOUtils.closeQuietly((Reader)this.in);
    }

    protected List<String> getSqlList() throws IOException {
        int count = 0;
        int size = 0;
        ArrayList<String> list = new ArrayList<String>();
        String sql = this.context.getReader().getSql(this.in);
        while (sql != null) {
            list.add(sql);
            if (++count > this.context.getMaxCount() || (size += sql.length()) > this.context.getMaxSize()) break;
            sql = this.context.getReader().getSql(this.in);
        }
        return list;
    }

    @Override
    public synchronized SqlMetaData getMetaData() {
        if (this.metaData == null) {
            this.metaData = MetaDataUtils.getSqlMetaData(this.location, this.context);
        }
        return this.metaData;
    }

    public SqlLocationContext getContext() {
        return this.context;
    }

    public String getLocation() {
        return this.location;
    }
}

