/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.vendor.model;

import org.kuali.common.jdbc.model.context.ConnectionContext;
import org.kuali.common.jdbc.vendor.model.Vendors;
import org.kuali.common.util.Assert;

public enum VendorDefault {
    ORACLE("oracle", Vendors.Oracle.DBA, "oracle.jdbc.driver.OracleDriver"),
    MYSQL("mysql", Vendors.MySql.DBA, "com.mysql.jdbc.Driver");

    private final String code;
    private final ConnectionContext dba;
    private final String driver;

    private VendorDefault(String code, ConnectionContext dba, String driver) {
        Assert.noNulls((Object[])new Object[]{dba});
        Assert.noBlanks((String[])new String[]{code, driver});
        this.code = code;
        this.dba = dba;
        this.driver = driver;
    }

    public String getCode() {
        return this.code;
    }

    public ConnectionContext getDba() {
        return this.dba;
    }

    public String getDriver() {
        return this.driver;
    }
}

