/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.vendor.service;

import java.sql.Driver;
import java.util.List;
import java.util.Properties;
import org.kuali.common.jdbc.model.context.ConnectionContext;
import org.kuali.common.jdbc.sql.model.AdminSql;
import org.kuali.common.jdbc.sql.model.DbaSql;
import org.kuali.common.jdbc.vendor.model.DatabaseVendor;
import org.kuali.common.jdbc.vendor.model.VendorDefault;
import org.kuali.common.jdbc.vendor.model.VendorSql;
import org.kuali.common.jdbc.vendor.model.keys.Admin;
import org.kuali.common.jdbc.vendor.model.keys.Basic;
import org.kuali.common.jdbc.vendor.model.keys.Dba;
import org.kuali.common.jdbc.vendor.service.DatabaseVendorService;
import org.kuali.common.util.Assert;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.spring.env.EnvironmentService;
import org.kuali.common.util.spring.env.model.EnvironmentKeySuffix;

public class DefaultDatabaseVendorService
implements DatabaseVendorService {
    private final EnvironmentService env;
    private final VendorDefault vendorDefault;

    public DefaultDatabaseVendorService(EnvironmentService env, VendorDefault vendorDefault) {
        Assert.noNulls((Object[])new Object[]{env, vendorDefault});
        this.env = env;
        this.vendorDefault = vendorDefault;
    }

    @Override
    public DatabaseVendor getDatabaseVendor() {
        ConnectionContext dba = this.getDba();
        Class<? extends Driver> driver = this.getDriver();
        Properties sql = this.getSql();
        AdminSql adminSql = this.getAdminSql(sql);
        DbaSql dbaSql = this.getDbaSql(adminSql, sql);
        VendorSql vendorSql = new VendorSql(adminSql, dbaSql, sql);
        String url = this.getUrl(dba);
        return new DatabaseVendor(this.vendorDefault, dba, url, driver, vendorSql);
    }

    protected String getUrl(ConnectionContext dba) {
        String key = this.vendorDefault.getCode() + "." + Basic.URL.getValue();
        String defaultValue = dba.getUrl();
        String actualValue = this.env.getString(key, defaultValue);
        return actualValue;
    }

    protected DbaSql getDbaSql(AdminSql adminSql, Properties sql) {
        String before = this.getDbaBefore(this.vendorDefault.getCode() + "." + Dba.BEFORE.getValue(), adminSql, sql);
        String after = this.getDbaAfter(this.vendorDefault.getCode() + "." + Dba.AFTER.getValue(), adminSql, sql);
        return new DbaSql(before, after);
    }

    protected String getDbaBefore(String key, AdminSql adminSql, Properties sql) {
        return this.env.getString(key, adminSql.getValidate() + adminSql.getDrop() + adminSql.getCreate());
    }

    protected String getDbaAfter(String key, AdminSql adminSql, Properties sql) {
        return this.env.getString(key, adminSql.getValidate());
    }

    protected AdminSql getAdminSql(Properties sql) {
        String validate = sql.getProperty(this.vendorDefault.getCode() + "." + Admin.VALIDATE.getValue());
        String create = sql.getProperty(this.vendorDefault.getCode() + "." + Admin.CREATE.getValue());
        String drop = sql.getProperty(this.vendorDefault.getCode() + "." + Admin.DROP.getValue());
        return new AdminSql(validate, create, drop);
    }

    protected String getSql(String key, Properties sql) {
        String defaultValue = sql.getProperty(key);
        return this.env.getString(key, defaultValue);
    }

    protected Properties getSql() {
        List<EnvironmentKeySuffix> suffixes = this.getSqlKeySuffixes();
        Properties properties = new Properties();
        for (EnvironmentKeySuffix suffix : suffixes) {
            String key = this.vendorDefault.getCode() + "." + suffix.getValue();
            String sql = this.env.getString(key);
            properties.setProperty(key, sql);
        }
        return properties;
    }

    protected Class<? extends Driver> getDriver() {
        String driver = this.env.getString(this.vendorDefault.getCode() + "." + Basic.DRIVER.getValue(), this.vendorDefault.getDriver());
        return ReflectionUtils.getTypedClass((String)driver);
    }

    protected ConnectionContext getDba() {
        String dbaUrl = this.env.getString(this.vendorDefault.getCode() + "." + Dba.URL.getValue(), this.vendorDefault.getDba().getUrl());
        String dbaUsr = this.env.getString(this.vendorDefault.getCode() + "." + Dba.USERNAME.getValue(), this.vendorDefault.getDba().getCredentials().getUsername());
        String dbaPwd = this.env.getString(this.vendorDefault.getCode() + "." + Dba.PASSWORD.getValue(), this.vendorDefault.getDba().getCredentials().getPassword());
        return new ConnectionContext(dbaUrl, dbaUsr, dbaPwd);
    }

    protected List<EnvironmentKeySuffix> getSqlKeySuffixes() {
        return Admin.asList();
    }

    public EnvironmentService getEnv() {
        return this.env;
    }

    public VendorDefault getVendorDefault() {
        return this.vendorDefault;
    }
}

