/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.DelimiterMode;
import org.kuali.common.jdbc.LineSeparator;
import org.kuali.common.jdbc.SqlMetaData;
import org.kuali.common.jdbc.SqlReader;
import org.springframework.util.Assert;

public class DefaultSqlReader
implements SqlReader {
    public static final String DEFAULT_DELIMITER = "/";
    public static final DelimiterMode DEFAULT_DELIMITER_MODE = DelimiterMode.OWN_LINE;
    public static final LineSeparator DEFAULT_LINE_SEPARATOR = LineSeparator.LF;
    public static final List<String> DEFAULT_COMMENT_TOKENS = Arrays.asList("#", "--");
    public static final boolean DEFAULT_IS_TRIM = true;
    public static final boolean DEFAULT_IS_IGNORE_COMMENTS = true;
    String delimiter = "/";
    DelimiterMode delimiterMode = DEFAULT_DELIMITER_MODE;
    LineSeparator lineSeparator = DEFAULT_LINE_SEPARATOR;
    boolean trim = true;
    boolean ignoreComments = true;
    List<String> commentTokens = DEFAULT_COMMENT_TOKENS;

    @Override
    public SqlMetaData getMetaData(BufferedReader reader) throws IOException {
        Assert.notNull((Object)this.delimiter, (String)"delimiter is null");
        long count = 0L;
        long size = 0L;
        String line = reader.readLine();
        String trimmedLine = StringUtils.trimToNull((String)line);
        while (line != null) {
            size += (long)line.length();
            if (this.isEndOfSqlStatement(trimmedLine, this.delimiter, this.delimiterMode)) {
                ++count;
            }
            line = reader.readLine();
            trimmedLine = StringUtils.trimToNull((String)line);
        }
        SqlMetaData smd = new SqlMetaData();
        smd.setCount(count);
        smd.setSize(size);
        return smd;
    }

    @Override
    public List<String> getSql(BufferedReader reader) throws IOException {
        Assert.notNull((Object)this.delimiter, (String)"delimiter is null");
        String line = reader.readLine();
        String trimmedLine = StringUtils.trimToNull((String)line);
        StringBuilder sb = new StringBuilder();
        while (line != null) {
            if (this.isEndOfSqlStatement(trimmedLine, this.delimiter, this.delimiterMode)) {
                return Arrays.asList(this.getReturnValue(sb.toString() + line, this.trim, this.lineSeparator));
            }
            if (!this.ignore(this.ignoreComments, sb, trimmedLine, this.commentTokens)) {
                sb.append(line + this.lineSeparator.getValue());
            }
            line = reader.readLine();
            trimmedLine = StringUtils.trimToNull((String)line);
        }
        String result = this.getReturnValue(sb.toString(), this.trim, this.lineSeparator);
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    protected String getReturnValue(String sql, boolean trim, LineSeparator lineSeparator) {
        int endIndex;
        if (StringUtils.endsWith((CharSequence)sql, (CharSequence)this.delimiter)) {
            endIndex = sql.length() - this.delimiter.length();
            sql = StringUtils.substring((String)sql, (int)0, (int)endIndex);
        }
        if (trim) {
            sql = StringUtils.trimToNull((String)sql);
        }
        if (sql == null) {
            return null;
        }
        if (StringUtils.endsWith((CharSequence)sql, (CharSequence)lineSeparator.getValue())) {
            endIndex = sql.length() - lineSeparator.getValue().length();
            return StringUtils.substring((String)sql, (int)0, (int)endIndex);
        }
        return sql;
    }

    protected boolean isEndOfSqlStatement(String trimmedLine, String delimiter, DelimiterMode delimiterMode) {
        switch (delimiterMode) {
            case END_OF_LINE: {
                return StringUtils.endsWith((CharSequence)trimmedLine, (CharSequence)delimiter);
            }
            case OWN_LINE: {
                return StringUtils.equals((CharSequence)trimmedLine, (CharSequence)delimiter);
            }
        }
        throw new IllegalArgumentException("Delimiter mode '" + (Object)((Object)delimiterMode) + "' is unknown");
    }

    protected boolean proceed(String line, String trimmedLine, String delimiter, DelimiterMode delimiterMode) {
        if (line == null) {
            return false;
        }
        boolean endOfSqlStatement = this.isEndOfSqlStatement(trimmedLine, delimiter, delimiterMode);
        return !endOfSqlStatement;
    }

    protected boolean ignore(boolean ignoreComments, StringBuilder sql, String trimmedLine, List<String> commentTokens) {
        if (!ignoreComments) {
            return false;
        }
        if (!StringUtils.isBlank((CharSequence)sql.toString())) {
            return false;
        }
        boolean isComment = this.isSqlComment(trimmedLine, commentTokens);
        return isComment;
    }

    protected boolean isSqlComment(String trimmedLine, List<String> commentTokens) {
        for (String commentToken : commentTokens) {
            if (!StringUtils.startsWith((CharSequence)trimmedLine, (CharSequence)commentToken)) continue;
            return true;
        }
        return false;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public LineSeparator getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(LineSeparator lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public DelimiterMode getDelimiterMode() {
        return this.delimiterMode;
    }

    public void setDelimiterMode(DelimiterMode delimiterMode) {
        this.delimiterMode = delimiterMode;
    }

    public List<String> getCommentTokens() {
        return this.commentTokens;
    }

    public void setCommentTokens(List<String> commentTokens) {
        this.commentTokens = commentTokens;
    }
}

