/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;
import org.kuali.common.jdbc.SqlMetaData;
import org.kuali.common.jdbc.SqlReader;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.Assert;

public class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);

    public static long getSqlSize(List<SqlSupplier> suppliers) {
        long size = 0L;
        for (SqlSupplier supplier : suppliers) {
            SqlMetaData smd = supplier.getMetaData();
            size += smd.getSize();
        }
        return size;
    }

    public static long getSqlCount(List<SqlSupplier> suppliers) {
        long count = 0L;
        for (SqlSupplier supplier : suppliers) {
            SqlMetaData smd = supplier.getMetaData();
            count += smd.getCount();
        }
        return count;
    }

    public static final void closeQuietly(DataSource dataSource, Connection conn, Statement statement) {
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(dataSource, conn);
    }

    public static final void closeQuietly(Statement statement) {
        if (statement == null) {
            return;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void closeQuietly(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final void closeQuietly(DataSource dataSource, Connection conn) {
        if (conn == null && dataSource == null) {
            return;
        }
        Assert.notNull((Object)dataSource, (String)"dataSource is null but conn is not");
        try {
            logger.trace("releasing connection");
            DataSourceUtils.doReleaseConnection((Connection)conn, (DataSource)dataSource);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SqlMetaData getSqlMetaData(BufferedReader in, SqlReader reader) throws IOException {
        long count = 0L;
        long size = 0L;
        List<String> sql = reader.getSql(in);
        while (sql != null) {
            for (String s : sql) {
                ++count;
                size += (long)s.length();
            }
            sql = reader.getSql(in);
        }
        return new SqlMetaData(count, size);
    }
}

