/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc;

import javax.sql.DataSource;
import org.kuali.common.jdbc.JdbcMetaData;
import org.kuali.common.jdbc.JdbcService;
import org.kuali.common.jdbc.context.DatabaseProcessContext;
import org.kuali.common.util.LoggerUtils;
import org.kuali.common.util.execute.Executable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ShowSimpleConfigExecutable
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(ShowSimpleConfigExecutable.class);
    DatabaseProcessContext context;
    DataSource dataSource;
    JdbcService service;
    boolean skip;

    public void execute() {
        if (this.skip) {
            logger.info("Skipping execution");
            return;
        }
        Assert.notNull((Object)this.service, (String)"service is null");
        Assert.notNull((Object)this.context, (String)"context is null");
        Assert.notNull((Object)this.dataSource, (String)"dataSource is null");
        logger.info("------------------------------------------------------------------------");
        logger.info("JDBC Configuration");
        logger.info("------------------------------------------------------------------------");
        logger.info("Vendor - {}", (Object)this.context.getVendor());
        logger.info("URL - {}", (Object)this.context.getUrl());
        logger.info("User - {}", (Object)LoggerUtils.getUsername((String)this.context.getUsername()));
        logger.info("Password - {}", (Object)LoggerUtils.getPassword((String)this.context.getUsername(), (String)this.context.getPassword()));
        logger.info("Driver - {}", (Object)this.context.getDriver());
        logger.info("SQL Encoding - {}", (Object)this.context.getEncoding());
        JdbcMetaData metadata = this.service.getJdbcMetaData(this.dataSource);
        logger.info("Product Name - {}", (Object)metadata.getDatabaseProductName());
        logger.info("Product Version - {}", (Object)metadata.getDatabaseProductVersion());
        logger.info("Driver Name - {}", (Object)metadata.getDriverName());
        logger.info("Driver Version - {}", (Object)metadata.getDriverVersion());
        logger.info("------------------------------------------------------------------------");
    }

    public DatabaseProcessContext getContext() {
        return this.context;
    }

    public void setContext(DatabaseProcessContext context) {
        this.context = context;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcService getService() {
        return this.service;
    }

    public void setService(JdbcService service) {
        this.service = service;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

