/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.convert;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kuali.common.jdbc.convert.ConversionContext;
import org.kuali.common.jdbc.convert.ConversionResult;
import org.kuali.common.jdbc.convert.DirectoryContext;
import org.kuali.common.jdbc.convert.SqlConverter;
import org.kuali.common.util.Assert;
import org.kuali.common.util.SimpleScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryConverter {
    public static final String CONVERTED_EXTENSION = ".converted";
    private static final Logger logger = LoggerFactory.getLogger(DirectoryConverter.class);

    public void convert(DirectoryContext context) {
        logger.info("Scanning directory " + context.getDirectory().getAbsolutePath());
        logger.info("Included file pattern: " + context.getInclude());
        logger.info("Excluded file pattern: " + context.getExclude());
        SimpleScanner scanner = new SimpleScanner(context.getDirectory(), context.getInclude(), context.getExclude());
        List oldFiles = scanner.getFiles();
        logger.info("Found " + oldFiles.size() + " files for conversion");
        List<File> newFiles = this.getNewFiles(oldFiles);
        List<ConversionResult> results = this.convert(context, oldFiles, newFiles);
        logger.info("Conversion complete");
        if (context.getPostProcessor() != null) {
            logger.info("Initiating post conversion processor of type: " + context.getPostProcessor().getClass().getName());
            context.getPostProcessor().process(results);
        }
    }

    protected List<ConversionResult> convert(DirectoryContext context, List<File> oldFiles, List<File> newFiles) {
        Assert.isTrue((oldFiles.size() == newFiles.size() ? 1 : 0) != 0);
        SqlConverter converter = context.getConverter();
        ArrayList<ConversionResult> results = new ArrayList<ConversionResult>();
        for (int i = 0; i < oldFiles.size(); ++i) {
            File oldFile = oldFiles.get(i);
            File newFile = newFiles.get(i);
            ConversionContext cc = new ConversionContext();
            cc.setNewFile(newFile);
            cc.setOldFile(oldFile);
            ConversionResult result = converter.convert(cc);
            results.add(result);
        }
        return results;
    }

    protected List<File> getNewFiles(List<File> oldFiles) {
        ArrayList<File> newFiles = new ArrayList<File>();
        for (File oldFile : oldFiles) {
            File newFile = new File(oldFile.getAbsolutePath() + CONVERTED_EXTENSION);
            newFiles.add(newFile);
        }
        return newFiles;
    }
}

