/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.listener.BucketEvent;
import org.kuali.common.jdbc.listener.NoOpSqlListener;
import org.kuali.common.jdbc.listener.SqlListener;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.jdbc.threads.SqlBucket;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketListener
extends NoOpSqlListener
implements SqlListener {
    private static final Logger logger = LoggerFactory.getLogger(BucketListener.class);
    LoggerLevel level = LoggerLevel.DEBUG;

    @Override
    public void bucketsCreated(BucketEvent event) {
        List<SqlBucket> buckets = event.getBuckets();
        ArrayList<Object[]> argsList = new ArrayList<Object[]>();
        for (int i = 0; i < buckets.size(); ++i) {
            SqlBucket bucket = buckets.get(i);
            List<SqlSupplier> suppliers = bucket.getSuppliers();
            String count = FormatUtils.getCount((long)JdbcUtils.getSqlCount(suppliers));
            String srcs = FormatUtils.getCount((long)suppliers.size());
            String size = FormatUtils.getSize((long)JdbcUtils.getSqlSize(suppliers));
            Object[] args = new Object[]{i + 1, count, srcs, size};
            argsList.add(args);
        }
        List<String> columns = Arrays.asList("Bucket", "SQL Count", "Sources", "Size");
        LoggerUtils.logTable(columns, argsList, (LoggerLevel)this.level, (Logger)logger);
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggerLevel level) {
        this.level = level;
    }
}

