/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import org.kuali.common.jdbc.listener.LogSqlMode;
import org.kuali.common.jdbc.listener.NoOpSqlListener;
import org.kuali.common.jdbc.listener.SqlEvent;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggerUtils;
import org.kuali.common.util.Str;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogSqlListener
extends NoOpSqlListener {
    private static final Logger logger = LoggerFactory.getLogger(LogSqlListener.class);
    public static final LoggerLevel DEFAULT_LOGGER_LEVEL = LoggerLevel.TRACE;
    public static final LogSqlMode DEFAULT_MODE = LogSqlMode.AFTER;
    LoggerLevel level = DEFAULT_LOGGER_LEVEL;
    boolean flatten = true;
    LogSqlMode mode = DEFAULT_MODE;

    public LogSqlListener() {
        this(DEFAULT_LOGGER_LEVEL, DEFAULT_MODE);
    }

    public LogSqlListener(LoggerLevel level, LogSqlMode mode) {
        this.level = level;
        this.mode = mode;
    }

    @Override
    public void beforeExecuteSql(SqlEvent event) {
        switch (this.mode) {
            case BEFORE: 
            case BOTH: {
                String sql = this.getSql(event.getSql(), this.flatten);
                LoggerUtils.logMsg((String)sql, (Logger)logger, (LoggerLevel)this.level);
                return;
            }
            case AFTER: {
                return;
            }
        }
        throw new IllegalArgumentException("Mode [" + (Object)((Object)this.mode) + "] is unknown");
    }

    @Override
    public void afterExecuteSql(SqlEvent event) {
        switch (this.mode) {
            case BEFORE: {
                return;
            }
            case BOTH: 
            case AFTER: {
                String sql = this.getSql(event.getSql(), this.flatten);
                String elapsed = FormatUtils.getTime((long)(event.getStopTimeMillis() - event.getStartTimeMillis()));
                Object[] args = new Object[]{sql, elapsed};
                LoggerUtils.logMsg((String)"{} - {}", (Object[])args, (Logger)logger, (LoggerLevel)this.level);
                return;
            }
        }
        throw new IllegalArgumentException("Mode [" + (Object)((Object)this.mode) + "] is unknown");
    }

    protected String getSql(String sql, boolean flatten) {
        if (flatten) {
            return "[" + Str.flatten((String)sql) + "]";
        }
        return sql;
    }

    public LoggerLevel getLevel() {
        return this.level;
    }

    public void setLevel(LoggerLevel level) {
        this.level = level;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public LogSqlMode getMode() {
        return this.mode;
    }

    public void setMode(LogSqlMode mode) {
        this.mode = mode;
    }
}

