/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import java.util.ArrayList;
import java.util.List;
import org.kuali.common.jdbc.listener.BucketEvent;
import org.kuali.common.jdbc.listener.SqlEvent;
import org.kuali.common.jdbc.listener.SqlExecutionEvent;
import org.kuali.common.jdbc.listener.SqlListener;
import org.kuali.common.jdbc.listener.SqlMetaDataEvent;

public class NotifyingListener
implements SqlListener {
    List<SqlListener> listeners = new ArrayList<SqlListener>();

    public NotifyingListener() {
        this(null);
    }

    public NotifyingListener(List<SqlListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void beforeMetaData(SqlMetaDataEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.beforeMetaData(event);
        }
    }

    @Override
    public void afterMetaData(SqlMetaDataEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.afterMetaData(event);
        }
    }

    @Override
    public void beforeExecution(SqlExecutionEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.beforeExecution(event);
        }
    }

    @Override
    public void bucketsCreated(BucketEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.bucketsCreated(event);
        }
    }

    @Override
    public void beforeExecuteSql(SqlEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.beforeExecuteSql(event);
        }
    }

    @Override
    public void afterExecuteSql(SqlEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.afterExecuteSql(event);
        }
    }

    @Override
    public void afterExecution(SqlExecutionEvent event) {
        for (SqlListener listener : this.listeners) {
            listener.afterExecution(event);
        }
    }

    public List<SqlListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<SqlListener> listeners) {
        this.listeners = listeners;
    }
}

