/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.listener.NoOpSqlListener;
import org.kuali.common.jdbc.listener.SqlEvent;
import org.kuali.common.jdbc.listener.SqlExecutionEvent;
import org.kuali.common.util.PercentCompleteInformer;

public class ProgressListener
extends NoOpSqlListener {
    PercentCompleteInformer informer = new PercentCompleteInformer();
    boolean startInformer = true;

    @Override
    public synchronized void beforeExecution(SqlExecutionEvent event) {
        this.informer.setTotal(JdbcUtils.getSqlCount(event.getContext().getSuppliers()));
    }

    @Override
    public synchronized void afterExecuteSql(SqlEvent event) {
        if (this.startInformer) {
            this.informer.start();
            this.startInformer = false;
        }
        this.informer.incrementProgress();
    }

    @Override
    public void afterExecution(SqlExecutionEvent event) {
        this.informer.stop();
    }

    public PercentCompleteInformer getInformer() {
        return this.informer;
    }

    public void setInformer(PercentCompleteInformer informer) {
        this.informer = informer;
    }
}

