/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.listener;

import org.kuali.common.jdbc.JdbcUtils;
import org.kuali.common.jdbc.listener.NoOpSqlListener;
import org.kuali.common.jdbc.listener.SqlExecutionEvent;
import org.kuali.common.jdbc.listener.SqlMetaDataEvent;
import org.kuali.common.util.FormatUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.LoggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryListener
extends NoOpSqlListener {
    private static final Logger logger = LoggerFactory.getLogger(SummaryListener.class);
    long count;
    long size;
    LoggerLevel loggerLevel = LoggerLevel.INFO;
    boolean showRate = true;

    public SummaryListener() {
        this(true);
    }

    public SummaryListener(boolean showRate) {
        this(showRate, LoggerLevel.INFO);
    }

    public SummaryListener(boolean showRate, LoggerLevel loggerLevel) {
        this.showRate = showRate;
        this.loggerLevel = loggerLevel;
    }

    @Override
    public void afterMetaData(SqlMetaDataEvent event) {
        this.count = JdbcUtils.getSqlCount(event.getContext().getSuppliers());
        this.size = JdbcUtils.getSqlSize(event.getContext().getSuppliers());
        String count = FormatUtils.getCount((long)this.count);
        String sources = FormatUtils.getCount((long)event.getContext().getSuppliers().size());
        String size = FormatUtils.getSize((long)this.size);
        Object[] args = new Object[]{count, sources, size};
        LoggerUtils.logMsg((String)"Executing - [SQL Count: {}  Sources: {}  Size: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
    }

    @Override
    public void afterExecution(SqlExecutionEvent event) {
        long elapsed = event.getStopTimeMillis() - event.getStartTimeMillis();
        String count = FormatUtils.getCount((long)this.count);
        String sources = FormatUtils.getCount((long)event.getContext().getSuppliers().size());
        String size = FormatUtils.getSize((long)this.size);
        String time = FormatUtils.getTime((long)elapsed);
        String rate = FormatUtils.getRate((long)elapsed, (long)this.size);
        String throughput = FormatUtils.getThroughputInSeconds((long)elapsed, (long)this.count, (String)"SQL/s");
        Object[] args = new Object[]{count, sources, size, time, throughput, rate};
        if (this.showRate) {
            LoggerUtils.logMsg((String)"Completed - [SQL Count: {}  Sources: {}  Size: {}  Time: {}  Throughput: {}  Rate: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
        } else {
            LoggerUtils.logMsg((String)"Completed - [SQL Count: {}  Sources: {}  Size: {}  Time: {}  Throughput: {}]", (Object[])args, (Logger)logger, (LoggerLevel)this.loggerLevel);
        }
    }

    public boolean isShowRate() {
        return this.showRate;
    }

    public void setShowRate(boolean showRate) {
        this.showRate = showRate;
    }
}

