/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.ArrayList;
import java.util.List;
import org.kuali.common.jdbc.JdbcExecutable;
import org.kuali.common.jdbc.context.SqlExecutionContext;
import org.kuali.common.jdbc.spring.JdbcCommonConfig;
import org.kuali.common.jdbc.spring.JdbcDataSourceConfig;
import org.kuali.common.jdbc.spring.SqlConfigContext;
import org.kuali.common.jdbc.spring.SqlConfigUtils;
import org.kuali.common.jdbc.spring.SqlDbaAfterConfig;
import org.kuali.common.jdbc.spring.SqlDbaBeforeConfig;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.execute.ExecutablesExecutable;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={JdbcCommonConfig.class, JdbcDataSourceConfig.class, SqlDbaBeforeConfig.class, SqlDbaAfterConfig.class})
public abstract class AbstractSqlController {
    @Autowired
    Environment env;
    @Autowired
    JdbcDataSourceConfig dataSourceConfig;
    @Autowired
    SqlDbaBeforeConfig dbaBeforeConfig;
    @Autowired
    SqlDbaAfterConfig dbaAfterConfig;
    @Autowired
    JdbcCommonConfig commonConfig;

    protected Executable getSqlExecutable() {
        ArrayList<Executable> executables = new ArrayList<Executable>();
        executables.add(this.dataSourceConfig.jdbcShowDbaConfigExecutable());
        executables.add(this.dbaBeforeConfig.getDbaPhaseExecutable());
        List<SqlExecutionContext> contexts = SqlConfigUtils.getSqlExecutionContexts(this.env);
        for (SqlExecutionContext context : contexts) {
            SqlConfigContext scc = new SqlConfigContext(this.env, context, this.commonConfig, this.dataSourceConfig);
            JdbcExecutable executable = SqlConfigUtils.getJdbcExecutable(scc);
            executables.add(executable);
        }
        executables.add(this.dbaAfterConfig.getDbaPhaseExecutable());
        ExecutablesExecutable exec = new ExecutablesExecutable();
        exec.setSkip(SpringUtils.getBoolean((Environment)this.env, (String)"jdbc.reset.skip", (boolean)false));
        exec.setTimed(SpringUtils.getBoolean((Environment)this.env, (String)"jdbc.reset.timed", (boolean)true));
        exec.setExecutables(executables);
        return exec;
    }
}

