/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.common.jdbc.DefaultJdbcService;
import org.kuali.common.jdbc.DefaultSqlReader;
import org.kuali.common.jdbc.JdbcProjectContext;
import org.kuali.common.jdbc.JdbcService;
import org.kuali.common.jdbc.SqlReader;
import org.kuali.common.jdbc.supplier.LocationSupplierSourceBean;
import org.kuali.common.jdbc.supplier.LocationSuppliersFactoryBean;
import org.kuali.common.jdbc.supplier.SqlLocationSupplier;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.util.Project;
import org.kuali.common.util.ProjectContext;
import org.kuali.common.util.ProjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
public class JdbcCommonConfig {
    @Autowired
    ConfigurableEnvironment env;

    @Bean
    public SqlReader jdbcSqlReader() {
        return new DefaultSqlReader();
    }

    @Bean
    public JdbcService jdbcService() {
        return new DefaultJdbcService();
    }

    @Bean
    public Map<String, LocationSupplierSourceBean> jdbcExtensionMappings() {
        Project project = ProjectUtils.loadProject((ProjectContext)new JdbcProjectContext());
        SqlLocationSupplier sls = new SqlLocationSupplier();
        sls.setReader(this.jdbcSqlReader());
        sls.setEncoding(project.getEncoding());
        LocationSupplierSourceBean lssb = new LocationSupplierSourceBean();
        lssb.setSupplierClass(SqlLocationSupplier.class);
        lssb.setSupplierInstance(sls);
        HashMap<String, LocationSupplierSourceBean> map = new HashMap<String, LocationSupplierSourceBean>();
        map.put("sql", lssb);
        return map;
    }

    public List<SqlSupplier> getSqlSuppliers(String propertyKey) {
        LocationSuppliersFactoryBean factory = new LocationSuppliersFactoryBean();
        factory.setPropertyKey(propertyKey);
        factory.setEnv((Environment)this.env);
        factory.setExtensionMappings(this.jdbcExtensionMappings());
        Object list = factory.getObject();
        return new ArrayList<SqlSupplier>((Collection<SqlSupplier>)list);
    }
}

