/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.Arrays;
import javax.sql.DataSource;
import org.kuali.common.jdbc.ShowConfigExecutable;
import org.kuali.common.jdbc.ShowSimpleConfigExecutable;
import org.kuali.common.jdbc.context.DatabaseProcessContext;
import org.kuali.common.jdbc.spring.JdbcCommonConfig;
import org.kuali.common.util.execute.Executable;
import org.kuali.common.util.nullify.DefaultBeanNullifier;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

@Configuration
@Import(value={JdbcCommonConfig.class})
public class JdbcDataSourceConfig {
    @Autowired
    Environment env;
    @Autowired
    JdbcCommonConfig commonConfig;

    @Bean
    public DatabaseProcessContext jdbcDatabaseProcessContext() {
        DatabaseProcessContext ctx = new DatabaseProcessContext();
        ctx.setVendor(SpringUtils.getProperty((Environment)this.env, (String)"db.vendor"));
        ctx.setDriver(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.driver"));
        ctx.setUrl(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.url"));
        ctx.setUsername(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.username"));
        ctx.setPassword(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.password"));
        ctx.setDbaUrl(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.dba.url"));
        ctx.setDbaUsername(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.dba.username"));
        ctx.setDbaPassword(SpringUtils.getProperty((Environment)this.env, (String)"jdbc.dba.password"));
        ctx.setEncoding(SpringUtils.getProperty((Environment)this.env, (String)"sql.encoding"));
        DefaultBeanNullifier nullifier = new DefaultBeanNullifier();
        nullifier.setBean((Object)ctx);
        nullifier.setNullTokens(Arrays.asList("NONE", "NULL"));
        nullifier.setProperties(Arrays.asList("username", "password", "dbaUsername", "dbaPassword"));
        nullifier.nullify();
        return ctx;
    }

    @Bean
    public DataSource jdbcDataSource() {
        DatabaseProcessContext ctx = this.jdbcDatabaseProcessContext();
        DriverManagerDataSource dmds = new DriverManagerDataSource();
        dmds.setDriverClassName(ctx.getDriver());
        dmds.setUrl(ctx.getUrl());
        dmds.setUsername(ctx.getUsername());
        dmds.setPassword(ctx.getPassword());
        return dmds;
    }

    @Bean
    public DataSource jdbcDbaDataSource() {
        DatabaseProcessContext ctx = this.jdbcDatabaseProcessContext();
        DriverManagerDataSource dmds = new DriverManagerDataSource();
        dmds.setDriverClassName(ctx.getDriver());
        dmds.setUrl(ctx.getDbaUrl());
        dmds.setUsername(ctx.getDbaUsername());
        dmds.setPassword(ctx.getDbaPassword());
        return dmds;
    }

    @Bean
    public Executable jdbcShowDbaConfigExecutable() {
        ShowConfigExecutable sce = new ShowConfigExecutable();
        sce.setService(this.commonConfig.jdbcService());
        sce.setContext(this.jdbcDatabaseProcessContext());
        sce.setDataSource(this.jdbcDbaDataSource());
        sce.setSkip(SpringUtils.getBoolean((Environment)this.env, (String)"jdbc.showconfig.skip", (boolean)false));
        return sce;
    }

    @Bean
    public Executable jdbcShowConfigExecutable() {
        ShowSimpleConfigExecutable sce = new ShowSimpleConfigExecutable();
        sce.setService(this.commonConfig.jdbcService());
        sce.setContext(this.jdbcDatabaseProcessContext());
        sce.setDataSource(this.jdbcDataSource());
        sce.setSkip(SpringUtils.getBoolean((Environment)this.env, (String)"jdbc.showconfig.skip", (boolean)false));
        return sce;
    }
}

