/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.spring;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.JdbcExecutable;
import org.kuali.common.jdbc.context.JdbcContext;
import org.kuali.common.jdbc.context.SqlExecutionContext;
import org.kuali.common.jdbc.context.SqlMode;
import org.kuali.common.jdbc.listener.DataSummaryListener;
import org.kuali.common.jdbc.listener.LogSqlListener;
import org.kuali.common.jdbc.listener.LogSqlMode;
import org.kuali.common.jdbc.listener.NotifyingListener;
import org.kuali.common.jdbc.listener.ProgressListener;
import org.kuali.common.jdbc.listener.SqlListener;
import org.kuali.common.jdbc.listener.SummaryListener;
import org.kuali.common.jdbc.spring.SqlConfigContext;
import org.kuali.common.jdbc.supplier.SqlSupplier;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.LoggerLevel;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class SqlConfigUtils {
    private static final Logger logger = LoggerFactory.getLogger(SqlConfigUtils.class);
    public static final String SQL_ORDER_KEY = "sql.execution.order";
    public static final String RESOURCES_SUFFIX = ".resources";

    public static JdbcExecutable getJdbcExecutable(SqlConfigContext scc) {
        String skipKey = "jdbc." + scc.getContext().getGroup() + ".skip";
        JdbcContext context = SqlConfigUtils.getJdbcContext(scc);
        context.setListener(SqlConfigUtils.getSqlListener(scc.getContext().getMode()));
        JdbcExecutable exec = new JdbcExecutable();
        exec.setSkip(SpringUtils.getBoolean((Environment)scc.getEnv(), (String)skipKey, (boolean)false));
        exec.setService(scc.getCommonConfig().jdbcService());
        exec.setContext(context);
        return exec;
    }

    public static SqlListener getSqlListener(SqlMode mode) {
        switch (mode) {
            case CONCURRENT: {
                return new LogSqlListener();
            }
            case SEQUENTIAL: {
                ArrayList<SqlListener> listeners = new ArrayList<SqlListener>();
                listeners.add(new LogSqlListener());
                listeners.add(new ProgressListener());
                return new NotifyingListener(listeners);
            }
        }
        throw new IllegalArgumentException("mode [" + mode.name() + "] is unknown");
    }

    public static JdbcContext getJdbcContext(SqlConfigContext scc) {
        SqlExecutionContext ctx = scc.getContext();
        SqlMode mode = ctx.getMode();
        switch (mode) {
            case CONCURRENT: {
                return SqlConfigUtils.getConcurrentJdbcContext(scc);
            }
            case SEQUENTIAL: {
                return SqlConfigUtils.getSequentialJdbcContext(scc);
            }
        }
        throw new IllegalArgumentException("mode [" + mode.name() + "] is unknown");
    }

    public static List<SqlExecutionContext> getSqlExecutionContexts(Environment env) {
        String csv = SpringUtils.getProperty((Environment)env, (String)SQL_ORDER_KEY);
        if (NullUtils.isNullOrNone((String)csv)) {
            csv = "";
        }
        List propertyKeys = CollectionUtils.getTrimmedListFromCSV((String)csv);
        SqlConfigUtils.validateSqlExecutionOrderValues(env, propertyKeys);
        return SqlConfigUtils.getSqlExecutionContexts(propertyKeys);
    }

    public static void validateSqlExecutionOrderValues(Environment env, List<String> propertykeys) {
        for (String propertyKey : propertykeys) {
            String csv = SpringUtils.getProperty((Environment)env, (String)propertyKey);
            List resources = CollectionUtils.getTrimmedListFromCSV((String)csv);
            SqlConfigUtils.validateResources(resources);
        }
    }

    public static void validateResources(List<String> resources) {
        for (String resource : resources) {
            LocationUtils.validateLocation((String)resource);
            if (!StringUtils.endsWithIgnoreCase((CharSequence)resource, (CharSequence)RESOURCES_SUFFIX)) continue;
            LocationUtils.validateLocationListing((String)resource);
        }
    }

    public static List<String> getLocations(Environment env, String key, String suffix) {
        ArrayList<String> locations = new ArrayList<String>();
        String value = SpringUtils.getProperty((Environment)env, (String)key);
        if (StringUtils.endsWithIgnoreCase((CharSequence)key, (CharSequence)suffix)) {
            locations.addAll(LocationUtils.getLocations((String)value));
        } else {
            locations.add(value);
        }
        return locations;
    }

    public static List<SqlExecutionContext> getSqlExecutionContexts(List<String> propertyKeys) {
        ArrayList<SqlExecutionContext> contexts = new ArrayList<SqlExecutionContext>();
        for (String propertyKey : propertyKeys) {
            String[] tokens = StringUtils.split((String)propertyKey, (String)".");
            Assert.isTrue((tokens.length >= 2 ? 1 : 0) != 0, (String)"tokens.length < 2");
            int groupIndex = tokens.length - 2;
            int modeIndex = tokens.length - 1;
            String group = StringUtils.trim((String)tokens[groupIndex]);
            String modeString = StringUtils.trim((String)tokens[modeIndex].toUpperCase());
            SqlMode mode = SqlMode.valueOf(modeString);
            contexts.add(new SqlExecutionContext(propertyKey, group, mode));
        }
        return contexts;
    }

    public static DataSummaryListener getConcurrentDataSummaryListener(SqlConfigContext scc) {
        String propertyKey = scc.getContext().getKey();
        String label = SpringUtils.getProperty((Environment)scc.getEnv(), (String)(propertyKey + ".progress.label"), (String)"Rows");
        String throughputLabel = SpringUtils.getProperty((Environment)scc.getEnv(), (String)(propertyKey + ".progress.label.throughput"), (String)"rows/s");
        DataSummaryListener dsl = new DataSummaryListener();
        dsl.setLabel(label);
        dsl.setThroughputLabel(throughputLabel);
        dsl.setLoggerLevel(LoggerLevel.DEBUG);
        return dsl;
    }

    public static JdbcContext getConcurrentJdbcContext(SqlConfigContext rcc) {
        String threads = SpringUtils.getProperty((Environment)rcc.getEnv(), (String)"sql.threads");
        JdbcContext ctx = SqlConfigUtils.getBaseJdbcContext(rcc);
        ctx.setMultithreaded(true);
        ctx.setThreads(new Integer(threads));
        return ctx;
    }

    public static JdbcContext getSequentialJdbcContext(SqlConfigContext rcc) {
        JdbcContext ctx = SqlConfigUtils.getBaseJdbcContext(rcc);
        ctx.setMultithreaded(false);
        ctx.setThreads(1);
        return ctx;
    }

    public static LogSqlListener getLogSqlListener(Environment env) {
        String level = SpringUtils.getProperty((Environment)env, (String)"sql.log.level", (String)LogSqlListener.DEFAULT_LOGGER_LEVEL.name());
        String mode = SpringUtils.getProperty((Environment)env, (String)"sql.log.mode", (String)LogSqlListener.DEFAULT_MODE.name());
        LogSqlListener lsl = new LogSqlListener();
        lsl.setLevel(LoggerLevel.valueOf((String)level));
        lsl.setMode(LogSqlMode.valueOf(mode));
        return lsl;
    }

    public static NotifyingListener getOtherListener(Environment env) {
        return SqlConfigUtils.getSummaryAndProgressListener(env);
    }

    protected static JdbcContext getBaseJdbcContext(SqlConfigContext scc) {
        SqlExecutionContext sec = scc.getContext();
        String group = sec.getGroup();
        String propertyKey = scc.getContext().getKey();
        String message = "[" + sec.getGroup() + ":" + sec.getMode().name().toLowerCase() + "]";
        boolean skip = SpringUtils.getBoolean((Environment)scc.getEnv(), (String)("sql." + group + ".skip"), (boolean)false);
        String key = propertyKey + ".trackProgressByUpdateCount";
        boolean trackProgressByUpdateCount = SpringUtils.getBoolean((Environment)scc.getEnv(), (String)key, (boolean)false);
        logger.debug("{}={}", (Object)key, (Object)trackProgressByUpdateCount);
        List<SqlSupplier> suppliers = scc.getCommonConfig().getSqlSuppliers(propertyKey);
        DataSource dataSource = scc.getDataSourceConfig().jdbcDataSource();
        JdbcContext ctx = new JdbcContext();
        ctx.setMessage(message);
        ctx.setSkip(skip);
        ctx.setDataSource(dataSource);
        ctx.setTrackProgressByUpdateCount(trackProgressByUpdateCount);
        ctx.setSuppliers(suppliers);
        return ctx;
    }

    public static NotifyingListener getConstraintsListener(Environment env) {
        ArrayList<SqlListener> list = new ArrayList<SqlListener>();
        list.add(new SummaryListener(false, LoggerLevel.DEBUG));
        list.add(SqlConfigUtils.getLogSqlListener(env));
        return new NotifyingListener(list);
    }

    public static NotifyingListener getSchemaListener(Environment env) {
        ArrayList<SqlListener> list = new ArrayList<SqlListener>();
        list.add(new SummaryListener(false, LoggerLevel.DEBUG));
        list.add(SqlConfigUtils.getLogSqlListener(env));
        return new NotifyingListener(list);
    }

    public static NotifyingListener getSummaryAndProgressListener(Environment env) {
        ArrayList<SqlListener> list = new ArrayList<SqlListener>();
        list.add(new SummaryListener(true, LoggerLevel.DEBUG));
        list.add(new ProgressListener());
        list.add(SqlConfigUtils.getLogSqlListener(env));
        return new NotifyingListener(list);
    }
}

