/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.jdbc.supplier;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.common.jdbc.supplier.LocationSupplier;
import org.kuali.common.jdbc.supplier.LocationSupplierSourceBean;
import org.kuali.common.util.Assert;
import org.kuali.common.util.CollectionUtils;
import org.kuali.common.util.LocationUtils;
import org.kuali.common.util.ReflectionUtils;
import org.kuali.common.util.nullify.NullUtils;
import org.kuali.common.util.spring.SpringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.env.Environment;

public class LocationSuppliersFactoryBean
implements FactoryBean<List<LocationSupplier>> {
    public static final String DEFAULT_RESOURCES_SUFFIX = ".resources";
    String resourcesSuffix = ".resources";
    Environment env;
    String propertyKey;
    Map<String, LocationSupplierSourceBean> extensionMappings;

    public List<LocationSupplier> getObject() {
        Assert.notNull((Object)this.env, (String)"env is null");
        Assert.notNull((Object)this.propertyKey, (String)"propertyKey is null");
        Assert.notNull(this.extensionMappings, (String)"extensionMappings is null");
        List<String> locations = this.getLocations(this.env, this.propertyKey, this.resourcesSuffix);
        return this.getSuppliers(locations, this.extensionMappings);
    }

    protected List<LocationSupplier> getSuppliers(List<String> locations, Map<String, LocationSupplierSourceBean> mappings) {
        ArrayList<LocationSupplier> suppliers = new ArrayList<LocationSupplier>();
        ArrayList<String> locationsToMap = new ArrayList<String>(locations);
        for (String suffix : mappings.keySet()) {
            ArrayList<String> matchedLocations = new ArrayList<String>();
            for (String location : locationsToMap) {
                if (!location.endsWith(suffix)) continue;
                LocationSupplierSourceBean sourceBean = mappings.get(suffix);
                suppliers.add(this.getLocationSupplierInstance(sourceBean, location));
                matchedLocations.add(location);
            }
            locationsToMap.removeAll(matchedLocations);
        }
        for (String location : locationsToMap) {
            String extension = FilenameUtils.getExtension((String)location);
            LocationSupplierSourceBean sourceBean = mappings.get(extension);
            if (sourceBean == null) {
                throw new IllegalArgumentException("Unknown extension [" + extension + "]");
            }
            suppliers.add(this.getLocationSupplierInstance(sourceBean, location));
        }
        return suppliers;
    }

    protected LocationSupplier getLocationSupplierInstance(LocationSupplierSourceBean sourceBean, String location) {
        LocationSupplier supplier = sourceBean.getSupplierInstance();
        LocationSupplier newInstance = (LocationSupplier)ReflectionUtils.newInstance(supplier.getClass());
        BeanUtils.copyProperties((Object)supplier, (Object)newInstance);
        newInstance.setLocation(location);
        return newInstance;
    }

    protected List<String> getLocations(Environment env, String propertyKey, String resourcesSuffix) {
        String csv = SpringUtils.getProperty((Environment)env, (String)propertyKey, (String)"NONE");
        if (NullUtils.isNullOrNone((String)csv)) {
            return new ArrayList<String>();
        }
        List resources = CollectionUtils.getTrimmedListFromCSV((String)csv);
        ArrayList<String> locations = new ArrayList<String>();
        for (String resource : resources) {
            if (StringUtils.endsWithIgnoreCase((CharSequence)resource, (CharSequence)resourcesSuffix)) {
                locations.addAll(LocationUtils.getLocations((String)resource));
                continue;
            }
            locations.add(resource);
        }
        return locations;
    }

    public Class<?> getObjectType() {
        return List.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public String getResourcesSuffix() {
        return this.resourcesSuffix;
    }

    public void setResourcesSuffix(String resourcesSuffix) {
        this.resourcesSuffix = resourcesSuffix;
    }

    public Environment getEnv() {
        return this.env;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public Map<String, LocationSupplierSourceBean> getExtensionMappings() {
        return this.extensionMappings;
    }

    public void setExtensionMappings(Map<String, LocationSupplierSourceBean> extensionMappings) {
        this.extensionMappings = extensionMappings;
    }
}

